package de.adorsys.datasafe.metainfo.version.impl.version.latest;

import de.adorsys.datasafe.directory.api.profile.operations.ProfileRetrievalService;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.privatestore.api.PrivateSpaceService;
import de.adorsys.datasafe.privatestore.api.actions.EncryptedResourceResolver;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import de.adorsys.datasafe.types.api.resource.StorageIdentifier;
import java.lang.Override;
import java.util.function.Function;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Generated(
        value = "de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator",
        comments = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used."
)
public class EncryptedLatestLinkServiceImplRuntimeDelegatable extends EncryptedLatestLinkServiceImpl {
    private final EncryptedLatestLinkServiceImpl delegate;

    /**
     * @param context Context class to search for overrides.
     */
    @Inject
    public EncryptedLatestLinkServiceImplRuntimeDelegatable(@Nullable OverridesRegistry context,
            EncryptedResourceResolver resolver, PrivateSpaceService privateSpace,
            ProfileRetrievalService profiles) {
        super(resolver, privateSpace, profiles);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(resolver, privateSpace, profiles);
        delegate = context != null ? context.findOverride(EncryptedLatestLinkServiceImpl.class, argumentsCaptor) : null;
    }

    @Override
    public AbsoluteLocation<PrivateResource> resolveLatestLinkLocation(UserIDAuth owner,
            PrivateResource resource, StorageIdentifier identifier) {
        if (null == delegate) {
            return super.resolveLatestLinkLocation(owner, resource, identifier);
        } else {
            return delegate.resolveLatestLinkLocation(owner, resource, identifier);
        }
    }

    @Override
    public Function<AbsoluteLocation<PrivateResource>, AbsoluteLocation<PrivateResource>> linkDecryptingReader(
            UserIDAuth owner, StorageIdentifier identifier) {
        if (null == delegate) {
            return super.linkDecryptingReader(owner, identifier);
        } else {
            return delegate.linkDecryptingReader(owner, identifier);
        }
    }

    /**
     * This is a typesafe function to register overriding class into context.
     */
    public static void overrideWith(OverridesRegistry context,
            Function<ArgumentsCaptor, EncryptedLatestLinkServiceImpl> ctorCaptor) {
        context.override(EncryptedLatestLinkServiceImpl.class, args -> ctorCaptor.apply((ArgumentsCaptor) args));
    }

    public static class ArgumentsCaptor {
        private final EncryptedResourceResolver resolver;

        private final PrivateSpaceService privateSpace;

        private final ProfileRetrievalService profiles;

        private ArgumentsCaptor(EncryptedResourceResolver resolver,
                PrivateSpaceService privateSpace, ProfileRetrievalService profiles) {
            this.resolver = resolver;
            this.privateSpace = privateSpace;
            this.profiles = profiles;
        }

        public EncryptedResourceResolver getResolver() {
            return resolver;
        }

        public PrivateSpaceService getPrivateSpace() {
            return privateSpace;
        }

        public ProfileRetrievalService getProfiles() {
            return profiles;
        }
    }
}
