package de.adorsys.datasafe.metainfo.version.impl.version.latest.actions;

import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.metainfo.version.api.version.EncryptedLatestLinkService;
import de.adorsys.datasafe.metainfo.version.impl.version.VersionEncoderDecoder;
import de.adorsys.datasafe.metainfo.version.impl.version.types.LatestDFSVersion;
import de.adorsys.datasafe.privatestore.api.PasswordClearingOutputStream;
import de.adorsys.datasafe.privatestore.api.actions.EncryptedResourceResolver;
import de.adorsys.datasafe.privatestore.api.actions.WriteToPrivate;
import de.adorsys.datasafe.types.api.actions.WriteRequest;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import java.lang.Override;
import java.util.function.Function;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Generated(
        value = "de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator",
        comments = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used."
)
public class LatestWriteImplRuntimeDelegatable<V extends LatestDFSVersion> extends LatestWriteImpl<V> {
    private final LatestWriteImpl<V> delegate;

    /**
     * @param context Context class to search for overrides.
     */
    @Inject
    public LatestWriteImplRuntimeDelegatable(@Nullable OverridesRegistry context, V strategy,
            VersionEncoderDecoder encoder, EncryptedResourceResolver encryptedResourceResolver,
            WriteToPrivate writeToPrivate, EncryptedLatestLinkService latestVersionLinkLocator) {
        super(strategy, encoder, encryptedResourceResolver, writeToPrivate, latestVersionLinkLocator);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(strategy, encoder, encryptedResourceResolver, writeToPrivate, latestVersionLinkLocator);
        delegate = context != null ? context.findOverride(LatestWriteImpl.class, argumentsCaptor) : null;
    }

    @Override
    public PasswordClearingOutputStream write(WriteRequest<UserIDAuth, PrivateResource> request) {
        if (null == delegate) {
            return super.write(request);
        } else {
            return delegate.write(request);
        }
    }

    @Override
    public V getStrategy() {
        if (null == delegate) {
            return super.getStrategy();
        } else {
            return delegate.getStrategy();
        }
    }

    /**
     * This is a typesafe function to register overriding class into context.
     */
    public static void overrideWith(OverridesRegistry context,
            Function<ArgumentsCaptor, LatestWriteImpl> ctorCaptor) {
        context.override(LatestWriteImpl.class, args -> ctorCaptor.apply((ArgumentsCaptor) args));
    }

    public static class ArgumentsCaptor<V extends LatestDFSVersion> {
        private final V strategy;

        private final VersionEncoderDecoder encoder;

        private final EncryptedResourceResolver encryptedResourceResolver;

        private final WriteToPrivate writeToPrivate;

        private final EncryptedLatestLinkService latestVersionLinkLocator;

        private ArgumentsCaptor(V strategy, VersionEncoderDecoder encoder,
                EncryptedResourceResolver encryptedResourceResolver, WriteToPrivate writeToPrivate,
                EncryptedLatestLinkService latestVersionLinkLocator) {
            this.strategy = strategy;
            this.encoder = encoder;
            this.encryptedResourceResolver = encryptedResourceResolver;
            this.writeToPrivate = writeToPrivate;
            this.latestVersionLinkLocator = latestVersionLinkLocator;
        }

        public V getStrategy() {
            return strategy;
        }

        public VersionEncoderDecoder getEncoder() {
            return encoder;
        }

        public EncryptedResourceResolver getEncryptedResourceResolver() {
            return encryptedResourceResolver;
        }

        public WriteToPrivate getWriteToPrivate() {
            return writeToPrivate;
        }

        public EncryptedLatestLinkService getLatestVersionLinkLocator() {
            return latestVersionLinkLocator;
        }
    }
}
