package de.adorsys.datasafe.metainfo.version.impl.version.latest.actions;

import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.metainfo.version.api.version.EncryptedLatestLinkService;
import de.adorsys.datasafe.metainfo.version.impl.version.types.LatestDFSVersion;
import de.adorsys.datasafe.privatestore.api.PasswordClearingInputStream;
import de.adorsys.datasafe.privatestore.api.actions.ReadFromPrivate;
import de.adorsys.datasafe.types.api.actions.ReadRequest;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import java.lang.Override;
import java.util.function.Function;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Generated(
        value = "de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator",
        comments = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used."
)
public class LatestReadImplRuntimeDelegatable<V extends LatestDFSVersion> extends LatestReadImpl<V> {
    private final LatestReadImpl<V> delegate;

    /**
     * @param context Context class to search for overrides.
     */
    @Inject
    public LatestReadImplRuntimeDelegatable(@Nullable OverridesRegistry context, V versionStrategy,
            ReadFromPrivate readFromPrivate, EncryptedLatestLinkService latestVersionLinkLocator) {
        super(versionStrategy, readFromPrivate, latestVersionLinkLocator);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(versionStrategy, readFromPrivate, latestVersionLinkLocator);
        delegate = context != null ? context.findOverride(LatestReadImpl.class, argumentsCaptor) : null;
    }

    @Override
    public PasswordClearingInputStream read(ReadRequest<UserIDAuth, PrivateResource> request) {
        if (null == delegate) {
            return super.read(request);
        } else {
            return delegate.read(request);
        }
    }

    @Override
    public V getStrategy() {
        if (null == delegate) {
            return super.getStrategy();
        } else {
            return delegate.getStrategy();
        }
    }

    /**
     * This is a typesafe function to register overriding class into context.
     */
    public static void overrideWith(OverridesRegistry context,
            Function<ArgumentsCaptor, LatestReadImpl> ctorCaptor) {
        context.override(LatestReadImpl.class, args -> ctorCaptor.apply((ArgumentsCaptor) args));
    }

    public static class ArgumentsCaptor<V extends LatestDFSVersion> {
        private final V versionStrategy;

        private final ReadFromPrivate readFromPrivate;

        private final EncryptedLatestLinkService latestVersionLinkLocator;

        private ArgumentsCaptor(V versionStrategy, ReadFromPrivate readFromPrivate,
                EncryptedLatestLinkService latestVersionLinkLocator) {
            this.versionStrategy = versionStrategy;
            this.readFromPrivate = readFromPrivate;
            this.latestVersionLinkLocator = latestVersionLinkLocator;
        }

        public V getVersionStrategy() {
            return versionStrategy;
        }

        public ReadFromPrivate getReadFromPrivate() {
            return readFromPrivate;
        }

        public EncryptedLatestLinkService getLatestVersionLinkLocator() {
            return latestVersionLinkLocator;
        }
    }
}
