/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.metainfo.version.impl.version.latest;

import com.google.common.base.Charsets;
import com.google.common.io.ByteStreams;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileRetrievalService;
import de.adorsys.datasafe.directory.api.types.UserPrivateProfile;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.metainfo.version.api.version.EncryptedLatestLinkService;
import de.adorsys.datasafe.privatestore.api.PrivateSpaceService;
import de.adorsys.datasafe.privatestore.api.actions.EncryptedResourceResolver;
import de.adorsys.datasafe.types.api.actions.ReadRequest;
import de.adorsys.datasafe.types.api.context.annotations.RuntimeDelegate;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import de.adorsys.datasafe.types.api.resource.StorageIdentifier;
import de.adorsys.datasafe.types.api.resource.Uri;
import de.adorsys.datasafe.types.api.utils.Obfuscate;
import java.io.InputStream;
import java.net.URI;
import java.util.function.Function;
import javax.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RuntimeDelegate
public class EncryptedLatestLinkServiceImpl
implements EncryptedLatestLinkService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EncryptedLatestLinkServiceImpl.class);
    private final ProfileRetrievalService profiles;
    private final EncryptedResourceResolver resolver;
    private final PrivateSpaceService privateSpace;

    @Inject
    public EncryptedLatestLinkServiceImpl(EncryptedResourceResolver resolver, PrivateSpaceService privateSpace, ProfileRetrievalService profiles) {
        this.resolver = resolver;
        this.privateSpace = privateSpace;
        this.profiles = profiles;
    }

    public AbsoluteLocation<PrivateResource> resolveLatestLinkLocation(UserIDAuth owner, PrivateResource resource, StorageIdentifier identifier) {
        UserPrivateProfile privateProfile = this.profiles.privateProfile(owner);
        if (null == privateProfile.getDocumentVersionStorage()) {
            log.error("Missing version storage for {}", (Object)Obfuscate.secure((String)owner.getUserID().getValue()));
            throw new IllegalStateException("User private profile is missing document version storage");
        }
        AbsoluteLocation encryptedPath = this.resolver.encryptAndResolvePath(owner, resource, identifier);
        return new AbsoluteLocation(encryptedPath.resolveFrom(privateProfile.getDocumentVersionStorage().getResource()));
    }

    public Function<AbsoluteLocation<PrivateResource>, AbsoluteLocation<PrivateResource>> linkDecryptingReader(UserIDAuth owner, StorageIdentifier identifier) {
        UserPrivateProfile privateProfile = this.profiles.privateProfile(owner);
        PrivateResource userPrivate = (PrivateResource)((AbsoluteLocation)privateProfile.getPrivateStorage().get(identifier)).getResource();
        Function decryptingResolver = this.resolver.decryptingResolver(owner, userPrivate, identifier);
        return latestLink -> {
            String relativeToPrivateUri = this.readLink(owner, (AbsoluteLocation<PrivateResource>)latestLink);
            PrivateResource resource = userPrivate.resolve(new Uri(URI.create(relativeToPrivateUri)), new Uri(""));
            return (AbsoluteLocation)decryptingResolver.apply(resource);
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readLink(UserIDAuth owner, AbsoluteLocation<PrivateResource> latestLink) {
        try (InputStream is = this.privateSpace.read(ReadRequest.forPrivate((Object)owner, (PrivateResource)((PrivateResource)latestLink.getResource())));){
            String string = new String(ByteStreams.toByteArray((InputStream)is), Charsets.UTF_8);
            return string;
        }
    }
}

