package de.adorsys.datasafe.metainfo.version.impl.version.latest;

import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import de.adorsys.datasafe.types.api.resource.Uri;
import de.adorsys.datasafe.types.api.resource.VersionedUri;
import java.lang.Override;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Generated(
        value = "de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator",
        comments = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used."
)
public class DefaultVersionEncoderDecoderRuntimeDelegatable extends DefaultVersionEncoderDecoder {
    private final DefaultVersionEncoderDecoder delegate;

    /**
     * @param context Context class to search for overrides.
     */
    @Inject
    public DefaultVersionEncoderDecoderRuntimeDelegatable(@Nullable OverridesRegistry context) {
        super();
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor();
        delegate = context != null ? context.findOverride(DefaultVersionEncoderDecoder.class, argumentsCaptor) : null;
    }

    @Override
    public VersionedUri newVersion(Uri resource) {
        if (null == delegate) {
            return super.newVersion(resource);
        } else {
            return delegate.newVersion(resource);
        }
    }

    @Override
    public Optional<VersionedUri> decodeVersion(Uri uri) {
        if (null == delegate) {
            return super.decodeVersion(uri);
        } else {
            return delegate.decodeVersion(uri);
        }
    }

    /**
     * This is a typesafe function to register overriding class into context.
     */
    public static void overrideWith(OverridesRegistry context,
            Function<ArgumentsCaptor, DefaultVersionEncoderDecoder> ctorCaptor) {
        context.override(DefaultVersionEncoderDecoder.class, args -> ctorCaptor.apply((ArgumentsCaptor) args));
    }

    public static class ArgumentsCaptor {
        private ArgumentsCaptor() {
        }
    }
}
