package de.adorsys.datasafe.metainfo.version.impl.version.latest.actions;

import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.metainfo.version.api.version.EncryptedLatestLinkService;
import de.adorsys.datasafe.metainfo.version.impl.version.types.LatestDFSVersion;
import de.adorsys.datasafe.privatestore.api.actions.RemoveFromPrivate;
import de.adorsys.datasafe.types.api.actions.RemoveRequest;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import java.lang.Override;
import java.util.function.Function;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Generated(
        value = "de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator",
        comments = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used."
)
public class LatestRemoveImplRuntimeDelegatable<V extends LatestDFSVersion> extends LatestRemoveImpl<V> {
    private final LatestRemoveImpl<V> delegate;

    /**
     * @param context Context class to search for overrides.
     */
    @Inject
    public LatestRemoveImplRuntimeDelegatable(@Nullable OverridesRegistry context,
            V versionStrategy, RemoveFromPrivate removeFromPrivate,
            EncryptedLatestLinkService latestVersionLinkLocator) {
        super(versionStrategy, removeFromPrivate, latestVersionLinkLocator);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(versionStrategy, removeFromPrivate, latestVersionLinkLocator);
        delegate = context != null ? context.findOverride(LatestRemoveImpl.class, argumentsCaptor) : null;
    }

    @Override
    public void remove(RemoveRequest<UserIDAuth, PrivateResource> request) {
        if (null == delegate) {
            super.remove(request);
        } else {
            delegate.remove(request);
        }
    }

    @Override
    public V getStrategy() {
        if (null == delegate) {
            return super.getStrategy();
        } else {
            return delegate.getStrategy();
        }
    }

    /**
     * This is a typesafe function to register overriding class into context.
     */
    public static void overrideWith(OverridesRegistry context,
            Function<ArgumentsCaptor, LatestRemoveImpl> ctorCaptor) {
        context.override(LatestRemoveImpl.class, args -> ctorCaptor.apply((ArgumentsCaptor) args));
    }

    public static class ArgumentsCaptor<V extends LatestDFSVersion> {
        private final V versionStrategy;

        private final RemoveFromPrivate removeFromPrivate;

        private final EncryptedLatestLinkService latestVersionLinkLocator;

        private ArgumentsCaptor(V versionStrategy, RemoveFromPrivate removeFromPrivate,
                EncryptedLatestLinkService latestVersionLinkLocator) {
            this.versionStrategy = versionStrategy;
            this.removeFromPrivate = removeFromPrivate;
            this.latestVersionLinkLocator = latestVersionLinkLocator;
        }

        public V getVersionStrategy() {
            return versionStrategy;
        }

        public RemoveFromPrivate getRemoveFromPrivate() {
            return removeFromPrivate;
        }

        public EncryptedLatestLinkService getLatestVersionLinkLocator() {
            return latestVersionLinkLocator;
        }
    }
}
