/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.metainfo.version.impl.version.latest;

import com.google.common.base.Charsets;
import com.google.common.io.ByteStreams;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileRetrievalService;
import de.adorsys.datasafe.directory.api.types.UserPrivateProfile;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.metainfo.version.api.version.EncryptedLatestLinkService;
import de.adorsys.datasafe.privatestore.api.PrivateSpaceService;
import de.adorsys.datasafe.privatestore.api.actions.EncryptedResourceResolver;
import de.adorsys.datasafe.types.api.actions.ReadRequest;
import de.adorsys.datasafe.types.api.context.annotations.RuntimeDelegate;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import de.adorsys.datasafe.types.api.resource.Uri;
import de.adorsys.datasafe.types.api.utils.Obfuscate;
import java.io.InputStream;
import javax.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RuntimeDelegate
public class EncryptedLatestLinkServiceImpl
implements EncryptedLatestLinkService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EncryptedLatestLinkServiceImpl.class);
    private final ProfileRetrievalService profiles;
    private final EncryptedResourceResolver resolver;
    private final PrivateSpaceService privateSpace;

    @Inject
    public EncryptedLatestLinkServiceImpl(EncryptedResourceResolver resolver, PrivateSpaceService privateSpace, ProfileRetrievalService profiles) {
        this.resolver = resolver;
        this.privateSpace = privateSpace;
        this.profiles = profiles;
    }

    public AbsoluteLocation<PrivateResource> resolveLatestLinkLocation(UserIDAuth owner, PrivateResource resource) {
        UserPrivateProfile privateProfile = this.profiles.privateProfile(owner);
        if (null == privateProfile.getDocumentVersionStorage()) {
            log.error("Missing version storage for {}", (Object)Obfuscate.secure((String)owner.getUserID().getValue()));
            throw new IllegalStateException("User private profile is missing document version storage");
        }
        AbsoluteLocation encryptedPath = this.resolver.encryptAndResolvePath(owner, resource);
        return new AbsoluteLocation(encryptedPath.resolveFrom(privateProfile.getDocumentVersionStorage().getResource()));
    }

    public AbsoluteLocation<PrivateResource> readLinkAndDecrypt(UserIDAuth owner, AbsoluteLocation<PrivateResource> latestLink) {
        UserPrivateProfile privateProfile = this.profiles.privateProfile(owner);
        String relativeToPrivateUri = this.readLink(owner, latestLink);
        PrivateResource userPrivate = (PrivateResource)privateProfile.getPrivateStorage().getResource();
        PrivateResource resource = ((PrivateResource)privateProfile.getPrivateStorage().getResource()).resolve(new Uri(relativeToPrivateUri), new Uri(""));
        return this.resolver.decryptAndResolvePath(owner, resource, userPrivate);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readLink(UserIDAuth owner, AbsoluteLocation<PrivateResource> latestLink) {
        try (InputStream is = this.privateSpace.read(ReadRequest.forPrivate((Object)owner, (PrivateResource)((PrivateResource)latestLink.getResource())));){
            String string = new String(ByteStreams.toByteArray((InputStream)is), Charsets.UTF_8);
            return string;
        }
    }
}

