/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.metainfo.version.impl.version.latest;

import de.adorsys.datasafe.metainfo.version.impl.version.VersionEncoderDecoder;
import de.adorsys.datasafe.types.api.context.annotations.RuntimeDelegate;
import de.adorsys.datasafe.types.api.resource.Uri;
import de.adorsys.datasafe.types.api.resource.VersionedUri;
import java.util.Optional;
import java.util.UUID;
import javax.inject.Inject;

@RuntimeDelegate
public class DefaultVersionEncoderDecoder
implements VersionEncoderDecoder {
    private static final String SEPARATOR = "/";

    @Inject
    public DefaultVersionEncoderDecoder() {
    }

    @Override
    public VersionedUri newVersion(Uri resource) {
        String version = UUID.randomUUID().toString();
        return new VersionedUri(new Uri(resource.toASCIIString() + SEPARATOR + version), resource, version);
    }

    @Override
    public Optional<VersionedUri> decodeVersion(Uri uri) {
        String[] parts = uri.getPath().split(SEPARATOR);
        if (parts.length < 2) {
            return Optional.empty();
        }
        try {
            UUID uuid = UUID.fromString(parts[parts.length - 1]);
            return Optional.of(new VersionedUri(uri, uri.resolve(".").asFile(), uuid.toString()));
        }
        catch (RuntimeException ex) {
            return Optional.empty();
        }
    }
}

