/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.metainfo.version.impl.version.latest.actions;

import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.metainfo.version.api.actions.VersionedWrite;
import de.adorsys.datasafe.metainfo.version.api.version.EncryptedLatestLinkService;
import de.adorsys.datasafe.metainfo.version.api.version.VersionEncoderDecoder;
import de.adorsys.datasafe.metainfo.version.impl.version.types.LatestDFSVersion;
import de.adorsys.datasafe.privatestore.api.actions.EncryptedResourceResolver;
import de.adorsys.datasafe.privatestore.api.actions.WriteToPrivate;
import de.adorsys.datasafe.types.api.actions.WriteRequest;
import de.adorsys.datasafe.types.api.context.annotations.RuntimeDelegate;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.BasePrivateResource;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import de.adorsys.datasafe.types.api.resource.ResourceLocation;
import de.adorsys.datasafe.types.api.resource.Uri;
import de.adorsys.datasafe.types.api.utils.Obfuscate;
import java.io.IOException;
import java.io.OutputStream;
import javax.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RuntimeDelegate
public class LatestWriteImpl<V extends LatestDFSVersion>
implements VersionedWrite<V> {
    private final V strategy;
    private final VersionEncoderDecoder encoder;
    private final EncryptedResourceResolver encryptedResourceResolver;
    private final WriteToPrivate writeToPrivate;
    private final EncryptedLatestLinkService latestVersionLinkLocator;

    @Inject
    public LatestWriteImpl(V strategy, VersionEncoderDecoder encoder, EncryptedResourceResolver encryptedResourceResolver, WriteToPrivate writeToPrivate, EncryptedLatestLinkService latestVersionLinkLocator) {
        this.strategy = strategy;
        this.encoder = encoder;
        this.encryptedResourceResolver = encryptedResourceResolver;
        this.writeToPrivate = writeToPrivate;
        this.latestVersionLinkLocator = latestVersionLinkLocator;
    }

    public OutputStream write(WriteRequest<UserIDAuth, PrivateResource> request) {
        AbsoluteLocation latestSnapshotLink = this.latestVersionLinkLocator.resolveLatestLinkLocation((UserIDAuth)request.getOwner(), (PrivateResource)request.getLocation());
        Uri decryptedPath = this.encoder.newVersion(((PrivateResource)request.getLocation()).location()).getPathWithVersion();
        PrivateResource resourceRelativeToPrivate = this.encryptPath((UserIDAuth)request.getOwner(), decryptedPath, (PrivateResource)request.getLocation());
        return new VersionCommittingStream(this.writeToPrivate.write(request.toBuilder().location((ResourceLocation)BasePrivateResource.forPrivate((Uri)decryptedPath)).build()), this.writeToPrivate, (WriteRequest<UserIDAuth, PrivateResource>)request.toBuilder().location(latestSnapshotLink.getResource()).build(), resourceRelativeToPrivate);
    }

    private PrivateResource encryptPath(UserIDAuth auth, Uri uri, PrivateResource base) {
        AbsoluteLocation resource = this.encryptedResourceResolver.encryptAndResolvePath(auth, base.resolve(uri, new Uri("")));
        return BasePrivateResource.forPrivate((Uri)((PrivateResource)resource.getResource()).encryptedPath());
    }

    @Generated
    public V getStrategy() {
        return this.strategy;
    }

    private static final class VersionCommittingStream
    extends OutputStream {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(VersionCommittingStream.class);
        private final OutputStream streamToWrite;
        private final WriteToPrivate writeToPrivate;
        private final WriteRequest<UserIDAuth, PrivateResource> request;
        private final PrivateResource writtenResource;

        @Override
        public void write(int b) throws IOException {
            this.streamToWrite.write(b);
        }

        @Override
        public void write(byte[] bytes, int off, int len) throws IOException {
            this.streamToWrite.write(bytes, off, len);
        }

        @Override
        public void close() {
            super.close();
            this.streamToWrite.close();
            log.debug("Committing file {} with blob {}", (Object)Obfuscate.secure((ResourceLocation)this.request.getLocation()), (Object)Obfuscate.secure((ResourceLocation)this.writtenResource));
            try (OutputStream os = this.writeToPrivate.write(this.request);){
                os.write(this.writtenResource.location().toASCIIString().getBytes());
            }
        }

        @Generated
        public VersionCommittingStream(OutputStream streamToWrite, WriteToPrivate writeToPrivate, WriteRequest<UserIDAuth, PrivateResource> request, PrivateResource writtenResource) {
            this.streamToWrite = streamToWrite;
            this.writeToPrivate = writeToPrivate;
            this.request = request;
            this.writtenResource = writtenResource;
        }
    }
}

