/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.metainfo.version.impl.version.latest;

import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.metainfo.version.api.version.EncryptedLatestLinkService;
import de.adorsys.datasafe.metainfo.version.api.version.VersionEncoderDecoder;
import de.adorsys.datasafe.metainfo.version.api.version.VersionInfoService;
import de.adorsys.datasafe.metainfo.version.impl.version.types.DFSVersion;
import de.adorsys.datasafe.privatestore.api.actions.ListPrivate;
import de.adorsys.datasafe.types.api.actions.ListRequest;
import de.adorsys.datasafe.types.api.context.annotations.RuntimeDelegate;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.BasePrivateResource;
import de.adorsys.datasafe.types.api.resource.BaseVersionedPath;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import de.adorsys.datasafe.types.api.resource.ResolvedResource;
import de.adorsys.datasafe.types.api.resource.Uri;
import de.adorsys.datasafe.types.api.resource.Version;
import de.adorsys.datasafe.types.api.resource.Versioned;
import de.adorsys.datasafe.types.api.resource.VersionedUri;
import java.util.Objects;
import java.util.stream.Stream;
import javax.inject.Inject;

@RuntimeDelegate
public class DefaultVersionInfoServiceImpl
implements VersionInfoService<DFSVersion> {
    private final VersionEncoderDecoder encoder;
    private final ListPrivate listPrivate;
    private final EncryptedLatestLinkService latestVersionLinkLocator;

    @Inject
    public DefaultVersionInfoServiceImpl(VersionEncoderDecoder encoder, ListPrivate listPrivate, EncryptedLatestLinkService latestVersionLinkLocator) {
        this.encoder = encoder;
        this.listPrivate = listPrivate;
        this.latestVersionLinkLocator = latestVersionLinkLocator;
    }

    public Stream<Versioned<AbsoluteLocation<ResolvedResource>, PrivateResource, DFSVersion>> versionsOf(ListRequest<UserIDAuth, PrivateResource> request) {
        return this.listPrivate.list(request).map(this::parseVersion).filter(Objects::nonNull);
    }

    public Stream<Versioned<AbsoluteLocation<ResolvedResource>, ResolvedResource, DFSVersion>> listJoinedWithLatest(ListRequest<UserIDAuth, PrivateResource> request) {
        return this.versionsOf(request).map(it -> this.resolveLatest(request, (Versioned<AbsoluteLocation<ResolvedResource>, PrivateResource, DFSVersion>)it));
    }

    private Versioned<AbsoluteLocation<ResolvedResource>, ResolvedResource, DFSVersion> resolveLatest(ListRequest<UserIDAuth, PrivateResource> request, Versioned<AbsoluteLocation<ResolvedResource>, PrivateResource, DFSVersion> versioned) {
        AbsoluteLocation latestLink = this.latestVersionLinkLocator.resolveLatestLinkLocation((UserIDAuth)request.getOwner(), (PrivateResource)versioned.stripVersion());
        AbsoluteLocation resolved = this.listPrivate.list(request.toBuilder().location(latestLink.getResource()).build()).findFirst().orElse(null);
        if (null == resolved) {
            return new BaseVersionedPath(versioned.getVersion(), (AbsoluteLocation)versioned.absolute(), null);
        }
        AbsoluteLocation latestObject = this.latestVersionLinkLocator.readLinkAndDecrypt((UserIDAuth)request.getOwner(), latestLink);
        return new BaseVersionedPath(versioned.getVersion(), (AbsoluteLocation)versioned.absolute(), (Object)((ResolvedResource)resolved.getResource()).withResource((PrivateResource)latestObject.getResource()));
    }

    private Versioned<AbsoluteLocation<ResolvedResource>, PrivateResource, DFSVersion> parseVersion(AbsoluteLocation<ResolvedResource> resource) {
        VersionedUri versionedUri = this.encoder.decodeVersion(((ResolvedResource)resource.getResource()).asPrivate().decryptedPath()).orElse(null);
        if (null == versionedUri) {
            return null;
        }
        return new BaseVersionedPath((Version)new DFSVersion(versionedUri.getVersion()), resource, (Object)BasePrivateResource.forPrivate((Uri)versionedUri.getPathWithoutVersion()));
    }
}

