package de.adorsys.datasafe.metainfo.version.impl.version.latest.actions;

import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.metainfo.version.api.version.EncryptedLatestLinkService;
import de.adorsys.datasafe.metainfo.version.api.version.VersionEncoderDecoder;
import de.adorsys.datasafe.metainfo.version.impl.version.types.LatestDFSVersion;
import de.adorsys.datasafe.privatestore.api.actions.ListPrivate;
import de.adorsys.datasafe.types.api.actions.ListRequest;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import de.adorsys.datasafe.types.api.resource.ResolvedResource;
import de.adorsys.datasafe.types.api.resource.Version;
import de.adorsys.datasafe.types.api.resource.Versioned;
import java.lang.Override;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Generated(
        value = "de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator",
        comments = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used."
)
public class LatestListImplRuntimeDelegatable<V extends LatestDFSVersion> extends LatestListImpl<V> {
    private final LatestListImpl<V> delegate;

    /**
     * @param context Context class to search for overrides.
     */
    @Inject
    public LatestListImplRuntimeDelegatable(@Nullable OverridesRegistry context, V strategy,
            VersionEncoderDecoder encoder, ListPrivate listPrivate,
            EncryptedLatestLinkService latestVersionLinkLocator) {
        super(strategy, encoder, listPrivate, latestVersionLinkLocator);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(strategy, encoder, listPrivate, latestVersionLinkLocator);
        delegate = context != null ? context.findOverride(LatestListImpl.class, argumentsCaptor) : null;
    }

    @Override
    public Stream<AbsoluteLocation<ResolvedResource>> list(
            ListRequest<UserIDAuth, PrivateResource> request) {
        if (null == delegate) {
            return super.list(request);
        } else {
            return delegate.list(request);
        }
    }

    @Override
    public Stream<Versioned<AbsoluteLocation<PrivateResource>, ResolvedResource, Version>> listVersioned(
            ListRequest<UserIDAuth, PrivateResource> request) {
        if (null == delegate) {
            return super.listVersioned(request);
        } else {
            return delegate.listVersioned(request);
        }
    }

    @Override
    public V getStrategy() {
        if (null == delegate) {
            return super.getStrategy();
        } else {
            return delegate.getStrategy();
        }
    }

    /**
     * This is a typesafe function to register overriding class into context.
     */
    public static void overrideWith(OverridesRegistry context,
            Function<ArgumentsCaptor, LatestListImpl> ctorCaptor) {
        context.override(LatestListImpl.class, args -> ctorCaptor.apply((ArgumentsCaptor) args));
    }

    public static class ArgumentsCaptor<V extends LatestDFSVersion> {
        private final V strategy;

        private final VersionEncoderDecoder encoder;

        private final ListPrivate listPrivate;

        private final EncryptedLatestLinkService latestVersionLinkLocator;

        private ArgumentsCaptor(V strategy, VersionEncoderDecoder encoder, ListPrivate listPrivate,
                EncryptedLatestLinkService latestVersionLinkLocator) {
            this.strategy = strategy;
            this.encoder = encoder;
            this.listPrivate = listPrivate;
            this.latestVersionLinkLocator = latestVersionLinkLocator;
        }

        public V getStrategy() {
            return strategy;
        }

        public VersionEncoderDecoder getEncoder() {
            return encoder;
        }

        public ListPrivate getListPrivate() {
            return listPrivate;
        }

        public EncryptedLatestLinkService getLatestVersionLinkLocator() {
            return latestVersionLinkLocator;
        }
    }
}
