package de.adorsys.datasafe.metainfo.version.impl.version.latest;

import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.metainfo.version.api.version.EncryptedLatestLinkService;
import de.adorsys.datasafe.metainfo.version.api.version.VersionEncoderDecoder;
import de.adorsys.datasafe.metainfo.version.impl.version.types.DFSVersion;
import de.adorsys.datasafe.privatestore.api.actions.ListPrivate;
import de.adorsys.datasafe.types.api.actions.ListRequest;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import de.adorsys.datasafe.types.api.resource.ResolvedResource;
import de.adorsys.datasafe.types.api.resource.Versioned;
import java.lang.Override;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Generated(
        value = "de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator",
        comments = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used."
)
public class DefaultVersionInfoServiceImplRuntimeDelegatable extends DefaultVersionInfoServiceImpl {
    private final DefaultVersionInfoServiceImpl delegate;

    /**
     * @param context Context class to search for overrides.
     */
    @Inject
    public DefaultVersionInfoServiceImplRuntimeDelegatable(@Nullable OverridesRegistry context,
            VersionEncoderDecoder encoder, ListPrivate listPrivate,
            EncryptedLatestLinkService latestVersionLinkLocator) {
        super(encoder, listPrivate, latestVersionLinkLocator);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(encoder, listPrivate, latestVersionLinkLocator);
        delegate = context != null ? context.findOverride(DefaultVersionInfoServiceImpl.class, argumentsCaptor) : null;
    }

    @Override
    public Stream<Versioned<AbsoluteLocation<ResolvedResource>, PrivateResource, DFSVersion>> versionsOf(
            ListRequest<UserIDAuth, PrivateResource> request) {
        if (null == delegate) {
            return super.versionsOf(request);
        } else {
            return delegate.versionsOf(request);
        }
    }

    @Override
    public Stream<Versioned<AbsoluteLocation<ResolvedResource>, ResolvedResource, DFSVersion>> listJoinedWithLatest(
            ListRequest<UserIDAuth, PrivateResource> request) {
        if (null == delegate) {
            return super.listJoinedWithLatest(request);
        } else {
            return delegate.listJoinedWithLatest(request);
        }
    }

    /**
     * This is a typesafe function to register overriding class into context.
     */
    public static void overrideWith(OverridesRegistry context,
            Function<ArgumentsCaptor, DefaultVersionInfoServiceImpl> ctorCaptor) {
        context.override(DefaultVersionInfoServiceImpl.class, args -> ctorCaptor.apply((ArgumentsCaptor) args));
    }

    public static class ArgumentsCaptor {
        private final VersionEncoderDecoder encoder;

        private final ListPrivate listPrivate;

        private final EncryptedLatestLinkService latestVersionLinkLocator;

        private ArgumentsCaptor(VersionEncoderDecoder encoder, ListPrivate listPrivate,
                EncryptedLatestLinkService latestVersionLinkLocator) {
            this.encoder = encoder;
            this.listPrivate = listPrivate;
            this.latestVersionLinkLocator = latestVersionLinkLocator;
        }

        public VersionEncoderDecoder getEncoder() {
            return encoder;
        }

        public ListPrivate getListPrivate() {
            return listPrivate;
        }

        public EncryptedLatestLinkService getLatestVersionLinkLocator() {
            return latestVersionLinkLocator;
        }
    }
}
