/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.inbox.impl.actions;

import de.adorsys.datasafe.directory.api.profile.keys.PrivateKeyService;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileRetrievalService;
import de.adorsys.datasafe.directory.api.resource.ResourceResolver;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.inbox.api.actions.ListInbox;
import de.adorsys.datasafe.storage.api.actions.StorageListService;
import de.adorsys.datasafe.types.api.actions.ListRequest;
import de.adorsys.datasafe.types.api.context.annotations.RuntimeDelegate;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import de.adorsys.datasafe.types.api.resource.ResolvedResource;
import de.adorsys.datasafe.types.api.resource.ResourceLocation;
import de.adorsys.datasafe.types.api.resource.Uri;
import java.util.stream.Stream;
import javax.inject.Inject;

@RuntimeDelegate
public class ListInboxImpl
implements ListInbox {
    private final PrivateKeyService keyService;
    private final ProfileRetrievalService profileRetrievalService;
    private final ResourceResolver resolver;
    private final StorageListService listService;

    @Inject
    public ListInboxImpl(PrivateKeyService keyService, ProfileRetrievalService profileRetrievalService, ResourceResolver resolver, StorageListService listService) {
        this.keyService = keyService;
        this.profileRetrievalService = profileRetrievalService;
        this.resolver = resolver;
        this.listService = listService;
    }

    public Stream<AbsoluteLocation<ResolvedResource>> list(ListRequest<UserIDAuth, PrivateResource> request) {
        this.keyService.validateUserHasAccessOrThrow((UserIDAuth)request.getOwner());
        return this.listService.list(this.resolveRelative(request)).map(it -> this.fillEncryptedDecryptedSegments(request, (AbsoluteLocation<ResolvedResource>)it));
    }

    private AbsoluteLocation<PrivateResource> resolveRelative(ListRequest<UserIDAuth, PrivateResource> request) {
        return this.resolver.resolveRelativeToPrivateInbox((UserIDAuth)request.getOwner(), (PrivateResource)request.getLocation());
    }

    private AbsoluteLocation<ResolvedResource> fillEncryptedDecryptedSegments(ListRequest<UserIDAuth, PrivateResource> request, AbsoluteLocation<ResolvedResource> resource) {
        AbsoluteLocation inboxPath = this.profileRetrievalService.publicProfile(((UserIDAuth)request.getOwner()).getUserID()).getInbox();
        Uri path = inboxPath.location().relativize(resource.location());
        return new AbsoluteLocation((ResourceLocation)((ResolvedResource)resource.getResource()).withResource(((ResolvedResource)resource.getResource()).asPrivate().resolve(path, path)));
    }
}

