package de.adorsys.datasafe.inbox.impl.actions;

import de.adorsys.datasafe.directory.api.profile.keys.PrivateKeyService;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileRetrievalService;
import de.adorsys.datasafe.directory.api.resource.ResourceResolver;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.storage.api.actions.StorageListService;
import de.adorsys.datasafe.types.api.actions.ListRequest;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import de.adorsys.datasafe.types.api.resource.ResolvedResource;
import java.lang.Override;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Generated(
        value = "de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator",
        comments = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used."
)
public class ListInboxImplRuntimeDelegatable extends ListInboxImpl {
    private final ListInboxImpl delegate;

    /**
     * @param context Context class to search for overrides.
     */
    @Inject
    public ListInboxImplRuntimeDelegatable(@Nullable OverridesRegistry context,
            PrivateKeyService keyService, ProfileRetrievalService profileRetrievalService,
            ResourceResolver resolver, StorageListService listService) {
        super(keyService, profileRetrievalService, resolver, listService);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(keyService, profileRetrievalService, resolver, listService);
        delegate = context != null ? context.findOverride(ListInboxImpl.class, argumentsCaptor) : null;
    }

    @Override
    public Stream<AbsoluteLocation<ResolvedResource>> list(
            ListRequest<UserIDAuth, PrivateResource> request) {
        if (null == delegate) {
            return super.list(request);
        } else {
            return delegate.list(request);
        }
    }

    /**
     * This is a typesafe function to register overriding class into context.
     */
    public static void overrideWith(OverridesRegistry context,
            Function<ArgumentsCaptor, ListInboxImpl> ctorCaptor) {
        context.override(ListInboxImpl.class, args -> ctorCaptor.apply((ArgumentsCaptor) args));
    }

    public static class ArgumentsCaptor {
        private final PrivateKeyService keyService;

        private final ProfileRetrievalService profileRetrievalService;

        private final ResourceResolver resolver;

        private final StorageListService listService;

        private ArgumentsCaptor(PrivateKeyService keyService,
                ProfileRetrievalService profileRetrievalService, ResourceResolver resolver,
                StorageListService listService) {
            this.keyService = keyService;
            this.profileRetrievalService = profileRetrievalService;
            this.resolver = resolver;
            this.listService = listService;
        }

        public PrivateKeyService getKeyService() {
            return keyService;
        }

        public ProfileRetrievalService getProfileRetrievalService() {
            return profileRetrievalService;
        }

        public ResourceResolver getResolver() {
            return resolver;
        }

        public StorageListService getListService() {
            return listService;
        }
    }
}
