package de.adorsys.datasafe.inbox.impl;

import de.adorsys.datasafe.inbox.api.actions.ListInbox;
import de.adorsys.datasafe.inbox.api.actions.ReadFromInbox;
import de.adorsys.datasafe.inbox.api.actions.RemoveFromInbox;
import de.adorsys.datasafe.inbox.api.actions.WriteToInbox;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import java.util.function.Function;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Generated(
        value = "de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator",
        comments = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used."
)
public class InboxServiceImplRuntimeDelegatable extends InboxServiceImpl {
    private final InboxServiceImpl delegate;

    /**
     * @param context Context class to search for overrides.
     */
    @Inject
    public InboxServiceImplRuntimeDelegatable(@Nullable OverridesRegistry context,
            ListInbox listInbox, ReadFromInbox readDocumentFromInbox,
            WriteToInbox writeDocumentToInbox, RemoveFromInbox removeFromInbox) {
        super(listInbox, readDocumentFromInbox, writeDocumentToInbox, removeFromInbox);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(listInbox, readDocumentFromInbox, writeDocumentToInbox, removeFromInbox);
        delegate = context != null ? context.findOverride(InboxServiceImpl.class, argumentsCaptor) : null;
    }

    /**
     * This is a typesafe function to register overriding class into context.
     */
    public static void overrideWith(OverridesRegistry context,
            Function<ArgumentsCaptor, InboxServiceImpl> ctorCaptor) {
        context.override(InboxServiceImpl.class, args -> ctorCaptor.apply((ArgumentsCaptor) args));
    }

    public static class ArgumentsCaptor {
        private final ListInbox listInbox;

        private final ReadFromInbox readDocumentFromInbox;

        private final WriteToInbox writeDocumentToInbox;

        private final RemoveFromInbox removeFromInbox;

        private ArgumentsCaptor(ListInbox listInbox, ReadFromInbox readDocumentFromInbox,
                WriteToInbox writeDocumentToInbox, RemoveFromInbox removeFromInbox) {
            this.listInbox = listInbox;
            this.readDocumentFromInbox = readDocumentFromInbox;
            this.writeDocumentToInbox = writeDocumentToInbox;
            this.removeFromInbox = removeFromInbox;
        }

        public ListInbox getListInbox() {
            return listInbox;
        }

        public ReadFromInbox getReadDocumentFromInbox() {
            return readDocumentFromInbox;
        }

        public WriteToInbox getWriteDocumentToInbox() {
            return writeDocumentToInbox;
        }

        public RemoveFromInbox getRemoveFromInbox() {
            return removeFromInbox;
        }
    }
}
