package de.adorsys.datasafe.inbox.impl.actions;

import de.adorsys.datasafe.directory.api.profile.keys.PrivateKeyService;
import de.adorsys.datasafe.directory.api.resource.ResourceResolver;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.storage.api.actions.StorageRemoveService;
import de.adorsys.datasafe.types.api.actions.RemoveRequest;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import java.lang.Override;
import java.util.function.Function;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Generated(
        value = "de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator",
        comments = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used."
)
public class RemoveFromInboxImplRuntimeDelegatable extends RemoveFromInboxImpl {
    private final RemoveFromInboxImpl delegate;

    /**
     * @param context Context class to search for overrides.
     */
    @Inject
    public RemoveFromInboxImplRuntimeDelegatable(@Nullable OverridesRegistry context,
            PrivateKeyService keyService, ResourceResolver resolver, StorageRemoveService remover) {
        super(keyService, resolver, remover);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(keyService, resolver, remover);
        delegate = context != null ? context.findOverride(RemoveFromInboxImpl.class, argumentsCaptor) : null;
    }

    @Override
    public void remove(RemoveRequest<UserIDAuth, PrivateResource> request) {
        if (null == delegate) {
            super.remove(request);
        } else {
            delegate.remove(request);
        }
    }

    /**
     * This is a typesafe function to register overriding class into context.
     */
    public static void overrideWith(OverridesRegistry context,
            Function<ArgumentsCaptor, RemoveFromInboxImpl> ctorCaptor) {
        context.override(RemoveFromInboxImpl.class, args -> ctorCaptor.apply((ArgumentsCaptor) args));
    }

    public static class ArgumentsCaptor {
        private final PrivateKeyService keyService;

        private final ResourceResolver resolver;

        private final StorageRemoveService remover;

        private ArgumentsCaptor(PrivateKeyService keyService, ResourceResolver resolver,
                StorageRemoveService remover) {
            this.keyService = keyService;
            this.resolver = resolver;
            this.remover = remover;
        }

        public PrivateKeyService getKeyService() {
            return keyService;
        }

        public ResourceResolver getResolver() {
            return resolver;
        }

        public StorageRemoveService getRemover() {
            return remover;
        }
    }
}
