/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.inbox.impl.actions;

import de.adorsys.datasafe.directory.api.profile.keys.PublicKeyService;
import de.adorsys.datasafe.directory.api.resource.ResourceResolver;
import de.adorsys.datasafe.encrypiton.api.document.EncryptedDocumentWriteService;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.inbox.api.actions.WriteToInbox;
import de.adorsys.datasafe.types.api.actions.WriteRequest;
import de.adorsys.datasafe.types.api.context.annotations.RuntimeDelegate;
import de.adorsys.datasafe.types.api.resource.PublicResource;
import java.io.OutputStream;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;

@RuntimeDelegate
public class WriteToInboxImpl
implements WriteToInbox {
    private final PublicKeyService publicKeyService;
    private final ResourceResolver resolver;
    private final EncryptedDocumentWriteService writer;

    @Inject
    public WriteToInboxImpl(PublicKeyService publicKeyService, ResourceResolver resolver, EncryptedDocumentWriteService writer) {
        this.publicKeyService = publicKeyService;
        this.resolver = resolver;
        this.writer = writer;
    }

    public OutputStream write(WriteRequest<Set<UserID>, PublicResource> request) {
        return this.writer.write(((Set)request.getOwner()).stream().collect(Collectors.toMap(arg_0 -> ((PublicKeyService)this.publicKeyService).publicKey(arg_0), it -> this.resolver.resolveRelativeToPublicInbox(it, (PublicResource)request.getLocation()))));
    }
}

