/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.inbox.impl.actions;

import de.adorsys.datasafe.directory.api.profile.keys.PublicKeyService;
import de.adorsys.datasafe.directory.api.resource.ResourceResolver;
import de.adorsys.datasafe.encrypiton.api.document.EncryptedDocumentWriteService;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.keystore.PublicKeyIDWithPublicKey;
import de.adorsys.datasafe.inbox.api.actions.WriteToInbox;
import de.adorsys.datasafe.types.api.actions.WriteRequest;
import de.adorsys.datasafe.types.api.context.annotations.RuntimeDelegate;
import de.adorsys.datasafe.types.api.resource.PublicResource;
import java.io.OutputStream;
import javax.inject.Inject;

@RuntimeDelegate
public class WriteToInboxImpl
implements WriteToInbox {
    private final PublicKeyService publicKeyService;
    private final ResourceResolver resolver;
    private final EncryptedDocumentWriteService writer;

    @Inject
    public WriteToInboxImpl(PublicKeyService publicKeyService, ResourceResolver resolver, EncryptedDocumentWriteService writer) {
        this.publicKeyService = publicKeyService;
        this.resolver = resolver;
        this.writer = writer;
    }

    public OutputStream write(WriteRequest<UserID, PublicResource> request) {
        PublicKeyIDWithPublicKey withPublicKey = this.publicKeyService.publicKey((UserID)request.getOwner());
        return this.writer.write(this.resolver.resolveRelativeToPublicInbox((UserID)request.getOwner(), (PublicResource)request.getLocation()), withPublicKey);
    }
}

