package de.adorsys.datasafe.inbox.impl.actions;

import de.adorsys.datasafe.directory.api.profile.keys.PublicKeyService;
import de.adorsys.datasafe.directory.api.resource.ResourceResolver;
import de.adorsys.datasafe.encrypiton.api.document.EncryptedDocumentWriteService;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.types.api.actions.WriteRequest;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import de.adorsys.datasafe.types.api.resource.PublicResource;
import java.io.OutputStream;
import java.lang.Override;
import java.util.function.Function;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Generated(
        value = "de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator",
        comments = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used."
)
public class WriteToInboxImplRuntimeDelegatable extends WriteToInboxImpl {
    private final WriteToInboxImpl delegate;

    /**
     * @param context Context class to search for overrides.
     */
    @Inject
    public WriteToInboxImplRuntimeDelegatable(@Nullable OverridesRegistry context,
            PublicKeyService publicKeyService, ResourceResolver resolver,
            EncryptedDocumentWriteService writer) {
        super(publicKeyService, resolver, writer);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(publicKeyService, resolver, writer);
        delegate = context != null ? context.findOverride(WriteToInboxImpl.class, argumentsCaptor) : null;
    }

    @Override
    public OutputStream write(WriteRequest<UserID, PublicResource> request) {
        if (null == delegate) {
            return super.write(request);
        } else {
            return delegate.write(request);
        }
    }

    /**
     * This is a typesafe function to register overriding class into context.
     */
    public static void overrideWith(OverridesRegistry context,
            Function<ArgumentsCaptor, WriteToInboxImpl> ctorCaptor) {
        context.override(WriteToInboxImpl.class, args -> ctorCaptor.apply((ArgumentsCaptor) args));
    }

    public static class ArgumentsCaptor {
        private final PublicKeyService publicKeyService;

        private final ResourceResolver resolver;

        private final EncryptedDocumentWriteService writer;

        private ArgumentsCaptor(PublicKeyService publicKeyService, ResourceResolver resolver,
                EncryptedDocumentWriteService writer) {
            this.publicKeyService = publicKeyService;
            this.resolver = resolver;
            this.writer = writer;
        }

        public PublicKeyService getPublicKeyService() {
            return publicKeyService;
        }

        public ResourceResolver getResolver() {
            return resolver;
        }

        public EncryptedDocumentWriteService getWriter() {
            return writer;
        }
    }
}
