/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.examples.business.filesystem;

import dagger.internal.DaggerGenerated;
import dagger.internal.DelegateFactory;
import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import de.adorsys.datasafe.business.impl.cmsencryption.DefaultCMSEncryptionModule_CmsEncryptionConfigFactory;
import de.adorsys.datasafe.business.impl.directory.DefaultKeystoreCacheModule_KeyStoreCacheFactory;
import de.adorsys.datasafe.business.impl.directory.DefaultProfileModule_CmsEncryptionConfigFactory;
import de.adorsys.datasafe.business.impl.directory.DefaultProfileModule_UserProfileCacheFactory;
import de.adorsys.datasafe.business.impl.keystore.DefaultKeyStoreModule_JugglerFactory;
import de.adorsys.datasafe.business.impl.keystore.DefaultKeyStoreModule_KeyStoreConfigFactory;
import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.directory.api.profile.dfs.BucketAccessService;
import de.adorsys.datasafe.directory.api.profile.keys.DocumentKeyStoreOperations;
import de.adorsys.datasafe.directory.api.profile.keys.PrivateKeyService;
import de.adorsys.datasafe.directory.api.profile.keys.PublicKeyService;
import de.adorsys.datasafe.directory.api.profile.keys.StorageKeyStoreOperations;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileOperations;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileRegistrationService;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileRemovalService;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileRetrievalService;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileStorageCredentialsService;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileUpdatingService;
import de.adorsys.datasafe.directory.api.resource.ResourceResolver;
import de.adorsys.datasafe.directory.impl.profile.dfs.BucketAccessServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.directory.impl.profile.dfs.BucketAccessServiceImplRuntimeDelegatable_Factory;
import de.adorsys.datasafe.directory.impl.profile.keys.DFSPrivateKeyServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.directory.impl.profile.keys.DFSPublicKeyServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.directory.impl.profile.keys.DocumentKeyStoreOperationsImplRuntimeDelegatable;
import de.adorsys.datasafe.directory.impl.profile.keys.GenericKeystoreOperations;
import de.adorsys.datasafe.directory.impl.profile.keys.GenericKeystoreOperations_Factory;
import de.adorsys.datasafe.directory.impl.profile.keys.KeyStoreCache;
import de.adorsys.datasafe.directory.impl.profile.keys.StorageKeyStoreOperationsImplRuntimeDelegatable;
import de.adorsys.datasafe.directory.impl.profile.keys.StorageKeyStoreOperationsImplRuntimeDelegatable_Factory;
import de.adorsys.datasafe.directory.impl.profile.operations.DFSBasedProfileStorageImplRuntimeDelegatable;
import de.adorsys.datasafe.directory.impl.profile.operations.UserProfileCache;
import de.adorsys.datasafe.directory.impl.profile.operations.actions.ProfileRegistrationServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.directory.impl.profile.operations.actions.ProfileRemovalServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.directory.impl.profile.operations.actions.ProfileRetrievalServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.directory.impl.profile.operations.actions.ProfileRetrievalServiceImplRuntimeDelegatable_Factory;
import de.adorsys.datasafe.directory.impl.profile.operations.actions.ProfileStorageCredentialsServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.directory.impl.profile.operations.actions.ProfileStoreService;
import de.adorsys.datasafe.directory.impl.profile.operations.actions.ProfileUpdatingServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.directory.impl.profile.resource.ResourceResolverImplRuntimeDelegatable;
import de.adorsys.datasafe.directory.impl.profile.serde.GsonSerde;
import de.adorsys.datasafe.directory.impl.profile.serde.GsonSerde_Factory;
import de.adorsys.datasafe.encrypiton.api.cmsencryption.CMSEncryptionService;
import de.adorsys.datasafe.encrypiton.api.document.EncryptedDocumentReadService;
import de.adorsys.datasafe.encrypiton.api.document.EncryptedDocumentWriteService;
import de.adorsys.datasafe.encrypiton.api.keystore.KeyStoreService;
import de.adorsys.datasafe.encrypiton.api.keystore.PublicKeySerde;
import de.adorsys.datasafe.encrypiton.api.types.encryption.CmsEncryptionConfig;
import de.adorsys.datasafe.encrypiton.api.types.encryption.EncryptionConfig;
import de.adorsys.datasafe.encrypiton.api.types.encryption.KeyCreationConfig;
import de.adorsys.datasafe.encrypiton.impl.cmsencryption.ASNCmsEncryptionConfig;
import de.adorsys.datasafe.encrypiton.impl.cmsencryption.CMSEncryptionServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.encrypiton.impl.document.CMSDocumentReadServiceRuntimeDelegatable;
import de.adorsys.datasafe.encrypiton.impl.document.CMSDocumentWriteServiceRuntimeDelegatable;
import de.adorsys.datasafe.encrypiton.impl.keystore.KeyStoreServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.encrypiton.impl.keystore.KeyStoreServiceImplRuntimeDelegatable_Factory;
import de.adorsys.datasafe.encrypiton.impl.keystore.PublicKeySerdeImplRuntimeDelegatable;
import de.adorsys.datasafe.encrypiton.impl.keystore.PublicKeySerdeImplRuntimeDelegatable_Factory;
import de.adorsys.datasafe.examples.business.filesystem.CustomPathEncryptionModule_PathEncryptionFactory;
import de.adorsys.datasafe.examples.business.filesystem.CustomlyBuiltDatasafeServices;
import de.adorsys.datasafe.inbox.api.InboxService;
import de.adorsys.datasafe.inbox.api.actions.ListInbox;
import de.adorsys.datasafe.inbox.api.actions.ReadFromInbox;
import de.adorsys.datasafe.inbox.api.actions.RemoveFromInbox;
import de.adorsys.datasafe.inbox.api.actions.WriteToInbox;
import de.adorsys.datasafe.inbox.impl.InboxServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.inbox.impl.actions.ListInboxImplRuntimeDelegatable;
import de.adorsys.datasafe.inbox.impl.actions.ReadFromInboxImplRuntimeDelegatable;
import de.adorsys.datasafe.inbox.impl.actions.RemoveFromInboxImplRuntimeDelegatable;
import de.adorsys.datasafe.inbox.impl.actions.WriteToInboxImplRuntimeDelegatable;
import de.adorsys.datasafe.privatestore.api.PrivateSpaceService;
import de.adorsys.datasafe.privatestore.api.actions.EncryptedResourceResolver;
import de.adorsys.datasafe.privatestore.api.actions.ListPrivate;
import de.adorsys.datasafe.privatestore.api.actions.ReadFromPrivate;
import de.adorsys.datasafe.privatestore.api.actions.RemoveFromPrivate;
import de.adorsys.datasafe.privatestore.api.actions.WriteToPrivate;
import de.adorsys.datasafe.privatestore.impl.PrivateSpaceServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.privatestore.impl.actions.EncryptedResourceResolverImplRuntimeDelegatable;
import de.adorsys.datasafe.privatestore.impl.actions.ListPrivateImplRuntimeDelegatable;
import de.adorsys.datasafe.privatestore.impl.actions.ReadFromPrivateImplRuntimeDelegatable;
import de.adorsys.datasafe.privatestore.impl.actions.RemoveFromPrivateImplRuntimeDelegatable;
import de.adorsys.datasafe.privatestore.impl.actions.WriteToPrivateImplRuntimeDelegatable;
import de.adorsys.datasafe.storage.api.StorageService;
import de.adorsys.datasafe.storage.api.actions.StorageCheckService;
import de.adorsys.datasafe.storage.api.actions.StorageListService;
import de.adorsys.datasafe.storage.api.actions.StorageReadService;
import de.adorsys.datasafe.storage.api.actions.StorageRemoveService;
import de.adorsys.datasafe.storage.api.actions.StorageWriteService;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import de.adorsys.keymanagement.api.Juggler;
import de.adorsys.keymanagement.api.config.keystore.KeyStoreConfig;
import javax.inject.Provider;

@DaggerGenerated
public final class DaggerCustomlyBuiltDatasafeServices {
    private DaggerCustomlyBuiltDatasafeServices() {
    }

    public static CustomlyBuiltDatasafeServices.Builder builder() {
        return new Builder();
    }

    private static final class Builder
    implements CustomlyBuiltDatasafeServices.Builder {
        private DFSConfig config;
        private StorageService storage;
        private OverridesRegistry overridesRegistry;
        private EncryptionConfig encryption;

        private Builder() {
        }

        @Override
        public Builder config(DFSConfig config) {
            this.config = (DFSConfig)Preconditions.checkNotNull((Object)config);
            return this;
        }

        @Override
        public Builder storage(StorageService storageService) {
            this.storage = (StorageService)Preconditions.checkNotNull((Object)storageService);
            return this;
        }

        @Override
        public Builder overridesRegistry(OverridesRegistry overridesRegistry) {
            this.overridesRegistry = overridesRegistry;
            return this;
        }

        @Override
        public Builder encryption(EncryptionConfig encryptionConfig) {
            this.encryption = encryptionConfig;
            return this;
        }

        @Override
        public CustomlyBuiltDatasafeServices build() {
            Preconditions.checkBuilderRequirement((Object)this.config, DFSConfig.class);
            Preconditions.checkBuilderRequirement((Object)this.storage, StorageService.class);
            return new CustomlyBuiltDatasafeServicesImpl(this.config, this.storage, this.overridesRegistry, this.encryption);
        }
    }

    private static final class CustomlyBuiltDatasafeServicesImpl
    implements CustomlyBuiltDatasafeServices {
        private final OverridesRegistry overridesRegistry;
        private final DFSConfig config;
        private final StorageService storage;
        private final EncryptionConfig encryption;
        private final CustomlyBuiltDatasafeServicesImpl customlyBuiltDatasafeServicesImpl = this;
        private Provider<OverridesRegistry> overridesRegistryProvider;
        private Provider<PublicKeySerdeImplRuntimeDelegatable> publicKeySerdeImplRuntimeDelegatableProvider;
        private Provider<GsonSerde> gsonSerdeProvider;
        private Provider<EncryptionConfig> encryptionProvider;
        private Provider<KeyStoreConfig> keyStoreConfigProvider;
        private Provider<Juggler> jugglerProvider;
        private Provider<KeyStoreServiceImplRuntimeDelegatable> keyStoreServiceImplRuntimeDelegatableProvider;
        private Provider<KeyCreationConfig> cmsEncryptionConfigProvider;
        private Provider<DFSConfig> configProvider;
        private Provider<StorageService> storageProvider;
        private Provider<KeyStoreCache> keyStoreCacheProvider;
        private Provider<GenericKeystoreOperations> genericKeystoreOperationsProvider;
        private Provider<StorageKeyStoreOperationsImplRuntimeDelegatable> storageKeyStoreOperationsImplRuntimeDelegatableProvider;
        private Provider<BucketAccessServiceImplRuntimeDelegatable> bucketAccessServiceImplRuntimeDelegatableProvider;
        private Provider<UserProfileCache> userProfileCacheProvider;
        private Provider<ProfileRetrievalServiceImplRuntimeDelegatable> profileRetrievalServiceImplRuntimeDelegatableProvider;

        private CustomlyBuiltDatasafeServicesImpl(DFSConfig configParam, StorageService storageParam, OverridesRegistry overridesRegistryParam, EncryptionConfig encryptionParam) {
            this.overridesRegistry = overridesRegistryParam;
            this.config = configParam;
            this.storage = storageParam;
            this.encryption = encryptionParam;
            this.initialize(configParam, storageParam, overridesRegistryParam, encryptionParam);
        }

        private BucketAccessServiceImplRuntimeDelegatable bucketAccessServiceImplRuntimeDelegatable() {
            return new BucketAccessServiceImplRuntimeDelegatable(this.overridesRegistry, DoubleCheck.lazy(this.storageKeyStoreOperationsImplRuntimeDelegatableProvider));
        }

        private PublicKeySerdeImplRuntimeDelegatable publicKeySerdeImplRuntimeDelegatable() {
            return new PublicKeySerdeImplRuntimeDelegatable(this.overridesRegistry);
        }

        private GsonSerde gsonSerde() {
            return new GsonSerde((PublicKeySerde)this.publicKeySerdeImplRuntimeDelegatable());
        }

        private ProfileRetrievalServiceImplRuntimeDelegatable profileRetrievalServiceImplRuntimeDelegatable() {
            return new ProfileRetrievalServiceImplRuntimeDelegatable(this.overridesRegistry, this.config, (StorageReadService)this.storage, (StorageCheckService)this.storage, (BucketAccessService)this.bucketAccessServiceImplRuntimeDelegatable(), this.gsonSerde(), (UserProfileCache)this.userProfileCacheProvider.get());
        }

        private ResourceResolverImplRuntimeDelegatable resourceResolverImplRuntimeDelegatable() {
            return new ResourceResolverImplRuntimeDelegatable(this.overridesRegistry, (ProfileRetrievalService)this.profileRetrievalServiceImplRuntimeDelegatable(), (BucketAccessService)this.bucketAccessServiceImplRuntimeDelegatable());
        }

        private EncryptedResourceResolverImplRuntimeDelegatable encryptedResourceResolverImplRuntimeDelegatable() {
            return new EncryptedResourceResolverImplRuntimeDelegatable(this.overridesRegistry, (BucketAccessService)this.bucketAccessServiceImplRuntimeDelegatable(), (ResourceResolver)this.resourceResolverImplRuntimeDelegatable(), CustomPathEncryptionModule_PathEncryptionFactory.pathEncryption());
        }

        private ListPrivateImplRuntimeDelegatable listPrivateImplRuntimeDelegatable() {
            return new ListPrivateImplRuntimeDelegatable(this.overridesRegistry, (EncryptedResourceResolver)this.encryptedResourceResolverImplRuntimeDelegatable(), (StorageListService)this.storage);
        }

        private KeyCreationConfig keyCreationConfig() {
            return DefaultProfileModule_CmsEncryptionConfigFactory.cmsEncryptionConfig((EncryptionConfig)this.encryption);
        }

        private KeyStoreConfig keyStoreConfig() {
            return DefaultKeyStoreModule_KeyStoreConfigFactory.keyStoreConfig((EncryptionConfig)this.encryption);
        }

        private Juggler juggler() {
            return DefaultKeyStoreModule_JugglerFactory.juggler((KeyStoreConfig)this.keyStoreConfig());
        }

        private KeyStoreServiceImplRuntimeDelegatable keyStoreServiceImplRuntimeDelegatable() {
            return new KeyStoreServiceImplRuntimeDelegatable(this.overridesRegistry, this.keyStoreConfig(), this.juggler());
        }

        private GenericKeystoreOperations genericKeystoreOperations() {
            return new GenericKeystoreOperations(this.keyCreationConfig(), this.config, (StorageWriteService)this.storage, (StorageReadService)this.storage, (KeyStoreCache)this.keyStoreCacheProvider.get(), (KeyStoreService)this.keyStoreServiceImplRuntimeDelegatable());
        }

        private DocumentKeyStoreOperationsImplRuntimeDelegatable documentKeyStoreOperationsImplRuntimeDelegatable() {
            return new DocumentKeyStoreOperationsImplRuntimeDelegatable(this.overridesRegistry, this.keyCreationConfig(), this.genericKeystoreOperations(), this.config, (BucketAccessService)this.bucketAccessServiceImplRuntimeDelegatable(), (ProfileRetrievalService)this.profileRetrievalServiceImplRuntimeDelegatable(), (StorageWriteService)this.storage, (KeyStoreCache)this.keyStoreCacheProvider.get(), (KeyStoreService)this.keyStoreServiceImplRuntimeDelegatable());
        }

        private DFSPrivateKeyServiceImplRuntimeDelegatable dFSPrivateKeyServiceImplRuntimeDelegatable() {
            return new DFSPrivateKeyServiceImplRuntimeDelegatable(this.overridesRegistry, (DocumentKeyStoreOperations)this.documentKeyStoreOperationsImplRuntimeDelegatable());
        }

        private CmsEncryptionConfig cmsEncryptionConfig() {
            return DefaultCMSEncryptionModule_CmsEncryptionConfigFactory.cmsEncryptionConfig((EncryptionConfig)this.encryption);
        }

        private ASNCmsEncryptionConfig aSNCmsEncryptionConfig() {
            return new ASNCmsEncryptionConfig(this.cmsEncryptionConfig());
        }

        private CMSEncryptionServiceImplRuntimeDelegatable cMSEncryptionServiceImplRuntimeDelegatable() {
            return new CMSEncryptionServiceImplRuntimeDelegatable(this.overridesRegistry, this.aSNCmsEncryptionConfig());
        }

        private CMSDocumentReadServiceRuntimeDelegatable cMSDocumentReadServiceRuntimeDelegatable() {
            return new CMSDocumentReadServiceRuntimeDelegatable(this.overridesRegistry, (StorageReadService)this.storage, (PrivateKeyService)this.dFSPrivateKeyServiceImplRuntimeDelegatable(), (CMSEncryptionService)this.cMSEncryptionServiceImplRuntimeDelegatable());
        }

        private ReadFromPrivateImplRuntimeDelegatable readFromPrivateImplRuntimeDelegatable() {
            return new ReadFromPrivateImplRuntimeDelegatable(this.overridesRegistry, (EncryptedResourceResolver)this.encryptedResourceResolverImplRuntimeDelegatable(), (EncryptedDocumentReadService)this.cMSDocumentReadServiceRuntimeDelegatable());
        }

        private CMSDocumentWriteServiceRuntimeDelegatable cMSDocumentWriteServiceRuntimeDelegatable() {
            return new CMSDocumentWriteServiceRuntimeDelegatable(this.overridesRegistry, (StorageWriteService)this.storage, (CMSEncryptionService)this.cMSEncryptionServiceImplRuntimeDelegatable());
        }

        private WriteToPrivateImplRuntimeDelegatable writeToPrivateImplRuntimeDelegatable() {
            return new WriteToPrivateImplRuntimeDelegatable(this.overridesRegistry, (PrivateKeyService)this.dFSPrivateKeyServiceImplRuntimeDelegatable(), (EncryptedResourceResolver)this.encryptedResourceResolverImplRuntimeDelegatable(), (EncryptedDocumentWriteService)this.cMSDocumentWriteServiceRuntimeDelegatable());
        }

        private RemoveFromPrivateImplRuntimeDelegatable removeFromPrivateImplRuntimeDelegatable() {
            return new RemoveFromPrivateImplRuntimeDelegatable(this.overridesRegistry, (EncryptedResourceResolver)this.encryptedResourceResolverImplRuntimeDelegatable(), (StorageRemoveService)this.storage);
        }

        private PrivateSpaceServiceImplRuntimeDelegatable privateSpaceServiceImplRuntimeDelegatable() {
            return new PrivateSpaceServiceImplRuntimeDelegatable(this.overridesRegistry, (ListPrivate)this.listPrivateImplRuntimeDelegatable(), (ReadFromPrivate)this.readFromPrivateImplRuntimeDelegatable(), (WriteToPrivate)this.writeToPrivateImplRuntimeDelegatable(), (RemoveFromPrivate)this.removeFromPrivateImplRuntimeDelegatable());
        }

        private ListInboxImplRuntimeDelegatable listInboxImplRuntimeDelegatable() {
            return new ListInboxImplRuntimeDelegatable(this.overridesRegistry, (PrivateKeyService)this.dFSPrivateKeyServiceImplRuntimeDelegatable(), (ProfileRetrievalService)this.profileRetrievalServiceImplRuntimeDelegatable(), (ResourceResolver)this.resourceResolverImplRuntimeDelegatable(), (StorageListService)this.storage);
        }

        private ReadFromInboxImplRuntimeDelegatable readFromInboxImplRuntimeDelegatable() {
            return new ReadFromInboxImplRuntimeDelegatable(this.overridesRegistry, (ResourceResolver)this.resourceResolverImplRuntimeDelegatable(), (EncryptedDocumentReadService)this.cMSDocumentReadServiceRuntimeDelegatable());
        }

        private DFSPublicKeyServiceImplRuntimeDelegatable dFSPublicKeyServiceImplRuntimeDelegatable() {
            return new DFSPublicKeyServiceImplRuntimeDelegatable(this.overridesRegistry, (KeyStoreCache)this.keyStoreCacheProvider.get(), (BucketAccessService)this.bucketAccessServiceImplRuntimeDelegatable(), (ProfileRetrievalService)this.profileRetrievalServiceImplRuntimeDelegatable(), (StorageReadService)this.storage, this.gsonSerde());
        }

        private WriteToInboxImplRuntimeDelegatable writeToInboxImplRuntimeDelegatable() {
            return new WriteToInboxImplRuntimeDelegatable(this.overridesRegistry, (PublicKeyService)this.dFSPublicKeyServiceImplRuntimeDelegatable(), (ResourceResolver)this.resourceResolverImplRuntimeDelegatable(), (EncryptedDocumentWriteService)this.cMSDocumentWriteServiceRuntimeDelegatable());
        }

        private RemoveFromInboxImplRuntimeDelegatable removeFromInboxImplRuntimeDelegatable() {
            return new RemoveFromInboxImplRuntimeDelegatable(this.overridesRegistry, (PrivateKeyService)this.dFSPrivateKeyServiceImplRuntimeDelegatable(), (ResourceResolver)this.resourceResolverImplRuntimeDelegatable(), (StorageRemoveService)this.storage);
        }

        private InboxServiceImplRuntimeDelegatable inboxServiceImplRuntimeDelegatable() {
            return new InboxServiceImplRuntimeDelegatable(this.overridesRegistry, (ListInbox)this.listInboxImplRuntimeDelegatable(), (ReadFromInbox)this.readFromInboxImplRuntimeDelegatable(), (WriteToInbox)this.writeToInboxImplRuntimeDelegatable(), (RemoveFromInbox)this.removeFromInboxImplRuntimeDelegatable());
        }

        private ProfileStoreService profileStoreService() {
            return new ProfileStoreService(this.gsonSerde(), (UserProfileCache)this.userProfileCacheProvider.get(), this.config, (BucketAccessService)this.bucketAccessServiceImplRuntimeDelegatable(), (StorageWriteService)this.storage);
        }

        private StorageKeyStoreOperationsImplRuntimeDelegatable storageKeyStoreOperationsImplRuntimeDelegatable() {
            return new StorageKeyStoreOperationsImplRuntimeDelegatable(this.overridesRegistry, this.gsonSerde(), (KeyStoreService)this.keyStoreServiceImplRuntimeDelegatable(), this.genericKeystoreOperations(), (ProfileRetrievalService)this.profileRetrievalServiceImplRuntimeDelegatable(), (BucketAccessService)this.bucketAccessServiceImplRuntimeDelegatable(), (KeyStoreCache)this.keyStoreCacheProvider.get());
        }

        private ProfileRegistrationServiceImplRuntimeDelegatable profileRegistrationServiceImplRuntimeDelegatable() {
            return new ProfileRegistrationServiceImplRuntimeDelegatable(this.overridesRegistry, this.profileStoreService(), (StorageKeyStoreOperations)this.storageKeyStoreOperationsImplRuntimeDelegatable(), (DocumentKeyStoreOperations)this.documentKeyStoreOperationsImplRuntimeDelegatable(), (BucketAccessService)this.bucketAccessServiceImplRuntimeDelegatable(), (StorageCheckService)this.storage, (StorageWriteService)this.storage, this.gsonSerde(), this.config);
        }

        private ProfileRemovalServiceImplRuntimeDelegatable profileRemovalServiceImplRuntimeDelegatable() {
            return new ProfileRemovalServiceImplRuntimeDelegatable(this.overridesRegistry, (PrivateKeyService)this.dFSPrivateKeyServiceImplRuntimeDelegatable(), (KeyStoreCache)this.keyStoreCacheProvider.get(), (UserProfileCache)this.userProfileCacheProvider.get(), (StorageListService)this.storage, (BucketAccessService)this.bucketAccessServiceImplRuntimeDelegatable(), this.config, (StorageRemoveService)this.storage, (ProfileRetrievalService)this.profileRetrievalServiceImplRuntimeDelegatable());
        }

        private ProfileUpdatingServiceImplRuntimeDelegatable profileUpdatingServiceImplRuntimeDelegatable() {
            return new ProfileUpdatingServiceImplRuntimeDelegatable(this.overridesRegistry, this.profileStoreService(), (PrivateKeyService)this.dFSPrivateKeyServiceImplRuntimeDelegatable(), (StorageKeyStoreOperations)this.storageKeyStoreOperationsImplRuntimeDelegatable(), (DocumentKeyStoreOperations)this.documentKeyStoreOperationsImplRuntimeDelegatable());
        }

        private ProfileStorageCredentialsServiceImplRuntimeDelegatable profileStorageCredentialsServiceImplRuntimeDelegatable() {
            return new ProfileStorageCredentialsServiceImplRuntimeDelegatable(this.overridesRegistry, (StorageKeyStoreOperations)this.storageKeyStoreOperationsImplRuntimeDelegatable(), (PrivateKeyService)this.dFSPrivateKeyServiceImplRuntimeDelegatable());
        }

        private DFSBasedProfileStorageImplRuntimeDelegatable dFSBasedProfileStorageImplRuntimeDelegatable() {
            return new DFSBasedProfileStorageImplRuntimeDelegatable(this.overridesRegistry, (ProfileRegistrationService)this.profileRegistrationServiceImplRuntimeDelegatable(), (ProfileRetrievalService)this.profileRetrievalServiceImplRuntimeDelegatable(), (ProfileRemovalService)this.profileRemovalServiceImplRuntimeDelegatable(), (ProfileUpdatingService)this.profileUpdatingServiceImplRuntimeDelegatable(), (ProfileStorageCredentialsService)this.profileStorageCredentialsServiceImplRuntimeDelegatable());
        }

        private void initialize(DFSConfig configParam, StorageService storageParam, OverridesRegistry overridesRegistryParam, EncryptionConfig encryptionParam) {
            this.overridesRegistryProvider = InstanceFactory.createNullable((Object)overridesRegistryParam);
            this.publicKeySerdeImplRuntimeDelegatableProvider = PublicKeySerdeImplRuntimeDelegatable_Factory.create(this.overridesRegistryProvider);
            this.gsonSerdeProvider = GsonSerde_Factory.create(this.publicKeySerdeImplRuntimeDelegatableProvider);
            this.encryptionProvider = InstanceFactory.createNullable((Object)encryptionParam);
            this.keyStoreConfigProvider = DefaultKeyStoreModule_KeyStoreConfigFactory.create(this.encryptionProvider);
            this.jugglerProvider = DefaultKeyStoreModule_JugglerFactory.create(this.keyStoreConfigProvider);
            this.keyStoreServiceImplRuntimeDelegatableProvider = KeyStoreServiceImplRuntimeDelegatable_Factory.create(this.overridesRegistryProvider, this.keyStoreConfigProvider, this.jugglerProvider);
            this.cmsEncryptionConfigProvider = DefaultProfileModule_CmsEncryptionConfigFactory.create(this.encryptionProvider);
            this.configProvider = InstanceFactory.create((Object)configParam);
            this.storageProvider = InstanceFactory.create((Object)storageParam);
            this.keyStoreCacheProvider = DoubleCheck.provider((Provider)DefaultKeystoreCacheModule_KeyStoreCacheFactory.create(this.overridesRegistryProvider));
            this.genericKeystoreOperationsProvider = GenericKeystoreOperations_Factory.create(this.cmsEncryptionConfigProvider, this.configProvider, this.storageProvider, this.storageProvider, this.keyStoreCacheProvider, this.keyStoreServiceImplRuntimeDelegatableProvider);
            this.storageKeyStoreOperationsImplRuntimeDelegatableProvider = new DelegateFactory();
            this.bucketAccessServiceImplRuntimeDelegatableProvider = BucketAccessServiceImplRuntimeDelegatable_Factory.create(this.overridesRegistryProvider, this.storageKeyStoreOperationsImplRuntimeDelegatableProvider);
            this.userProfileCacheProvider = DoubleCheck.provider((Provider)DefaultProfileModule_UserProfileCacheFactory.create(this.overridesRegistryProvider));
            this.profileRetrievalServiceImplRuntimeDelegatableProvider = ProfileRetrievalServiceImplRuntimeDelegatable_Factory.create(this.overridesRegistryProvider, this.configProvider, this.storageProvider, this.storageProvider, this.bucketAccessServiceImplRuntimeDelegatableProvider, this.gsonSerdeProvider, this.userProfileCacheProvider);
            DelegateFactory.setDelegate(this.storageKeyStoreOperationsImplRuntimeDelegatableProvider, (Provider)StorageKeyStoreOperationsImplRuntimeDelegatable_Factory.create(this.overridesRegistryProvider, this.gsonSerdeProvider, this.keyStoreServiceImplRuntimeDelegatableProvider, this.genericKeystoreOperationsProvider, this.profileRetrievalServiceImplRuntimeDelegatableProvider, this.bucketAccessServiceImplRuntimeDelegatableProvider, this.keyStoreCacheProvider));
        }

        @Override
        public PrivateSpaceService privateService() {
            return this.privateSpaceServiceImplRuntimeDelegatable();
        }

        @Override
        public InboxService inboxService() {
            return this.inboxServiceImplRuntimeDelegatable();
        }

        @Override
        public ProfileOperations userProfile() {
            return this.dFSBasedProfileStorageImplRuntimeDelegatable();
        }
    }
}

