package de.adorsys.datasafe.examples.business.filesystem;

import dagger.internal.DaggerGenerated;
import dagger.internal.DelegateFactory;
import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import de.adorsys.datasafe.business.impl.cmsencryption.DefaultCMSEncryptionModule_CmsEncryptionConfigFactory;
import de.adorsys.datasafe.business.impl.directory.DefaultKeystoreCacheModule_KeyStoreCacheFactory;
import de.adorsys.datasafe.business.impl.directory.DefaultProfileModule_CmsEncryptionConfigFactory;
import de.adorsys.datasafe.business.impl.directory.DefaultProfileModule_UserProfileCacheFactory;
import de.adorsys.datasafe.business.impl.keystore.DefaultKeyStoreModule_JugglerFactory;
import de.adorsys.datasafe.business.impl.keystore.DefaultKeyStoreModule_KeyStoreConfigFactory;
import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileOperations;
import de.adorsys.datasafe.directory.impl.profile.dfs.BucketAccessServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.directory.impl.profile.dfs.BucketAccessServiceImplRuntimeDelegatable_Factory;
import de.adorsys.datasafe.directory.impl.profile.keys.DFSPrivateKeyServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.directory.impl.profile.keys.DFSPublicKeyServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.directory.impl.profile.keys.DocumentKeyStoreOperationsImplRuntimeDelegatable;
import de.adorsys.datasafe.directory.impl.profile.keys.GenericKeystoreOperations;
import de.adorsys.datasafe.directory.impl.profile.keys.GenericKeystoreOperations_Factory;
import de.adorsys.datasafe.directory.impl.profile.keys.KeyStoreCache;
import de.adorsys.datasafe.directory.impl.profile.keys.StorageKeyStoreOperationsImplRuntimeDelegatable;
import de.adorsys.datasafe.directory.impl.profile.keys.StorageKeyStoreOperationsImplRuntimeDelegatable_Factory;
import de.adorsys.datasafe.directory.impl.profile.operations.DFSBasedProfileStorageImplRuntimeDelegatable;
import de.adorsys.datasafe.directory.impl.profile.operations.UserProfileCache;
import de.adorsys.datasafe.directory.impl.profile.operations.actions.ProfileRegistrationServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.directory.impl.profile.operations.actions.ProfileRemovalServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.directory.impl.profile.operations.actions.ProfileRetrievalServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.directory.impl.profile.operations.actions.ProfileRetrievalServiceImplRuntimeDelegatable_Factory;
import de.adorsys.datasafe.directory.impl.profile.operations.actions.ProfileStorageCredentialsServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.directory.impl.profile.operations.actions.ProfileStoreService;
import de.adorsys.datasafe.directory.impl.profile.operations.actions.ProfileUpdatingServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.directory.impl.profile.resource.ResourceResolverImplRuntimeDelegatable;
import de.adorsys.datasafe.directory.impl.profile.serde.GsonSerde;
import de.adorsys.datasafe.directory.impl.profile.serde.GsonSerde_Factory;
import de.adorsys.datasafe.encrypiton.api.types.encryption.CmsEncryptionConfig;
import de.adorsys.datasafe.encrypiton.api.types.encryption.EncryptionConfig;
import de.adorsys.datasafe.encrypiton.api.types.encryption.KeyCreationConfig;
import de.adorsys.datasafe.encrypiton.impl.cmsencryption.ASNCmsEncryptionConfig;
import de.adorsys.datasafe.encrypiton.impl.cmsencryption.CMSEncryptionServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.encrypiton.impl.document.CMSDocumentReadServiceRuntimeDelegatable;
import de.adorsys.datasafe.encrypiton.impl.document.CMSDocumentWriteServiceRuntimeDelegatable;
import de.adorsys.datasafe.encrypiton.impl.keystore.KeyStoreServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.encrypiton.impl.keystore.KeyStoreServiceImplRuntimeDelegatable_Factory;
import de.adorsys.datasafe.encrypiton.impl.keystore.PublicKeySerdeImplRuntimeDelegatable;
import de.adorsys.datasafe.encrypiton.impl.keystore.PublicKeySerdeImplRuntimeDelegatable_Factory;
import de.adorsys.datasafe.inbox.api.InboxService;
import de.adorsys.datasafe.inbox.impl.InboxServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.inbox.impl.actions.ListInboxImplRuntimeDelegatable;
import de.adorsys.datasafe.inbox.impl.actions.ReadFromInboxImplRuntimeDelegatable;
import de.adorsys.datasafe.inbox.impl.actions.RemoveFromInboxImplRuntimeDelegatable;
import de.adorsys.datasafe.inbox.impl.actions.WriteToInboxImplRuntimeDelegatable;
import de.adorsys.datasafe.privatestore.api.PrivateSpaceService;
import de.adorsys.datasafe.privatestore.impl.PrivateSpaceServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.privatestore.impl.actions.EncryptedResourceResolverImplRuntimeDelegatable;
import de.adorsys.datasafe.privatestore.impl.actions.ListPrivateImplRuntimeDelegatable;
import de.adorsys.datasafe.privatestore.impl.actions.ReadFromPrivateImplRuntimeDelegatable;
import de.adorsys.datasafe.privatestore.impl.actions.RemoveFromPrivateImplRuntimeDelegatable;
import de.adorsys.datasafe.privatestore.impl.actions.WriteToPrivateImplRuntimeDelegatable;
import de.adorsys.datasafe.storage.api.StorageService;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import de.adorsys.keymanagement.api.Juggler;
import de.adorsys.keymanagement.api.config.keystore.KeyStoreConfig;
import javax.annotation.processing.Generated;
import javax.inject.Provider;

@DaggerGenerated
@Generated(
    value = "dagger.internal.codegen.ComponentProcessor",
    comments = "https://dagger.dev"
)
@SuppressWarnings({
    "unchecked",
    "rawtypes",
    "KotlinInternal",
    "KotlinInternalInJava"
})
public final class DaggerCustomlyBuiltDatasafeServices {
  private DaggerCustomlyBuiltDatasafeServices() {
  }

  public static CustomlyBuiltDatasafeServices.Builder builder() {
    return new Builder();
  }

  private static final class Builder implements CustomlyBuiltDatasafeServices.Builder {
    private DFSConfig config;

    private StorageService storage;

    private OverridesRegistry overridesRegistry;

    private EncryptionConfig encryption;

    @Override
    public Builder config(DFSConfig config) {
      this.config = Preconditions.checkNotNull(config);
      return this;
    }

    @Override
    public Builder storage(StorageService storageService) {
      this.storage = Preconditions.checkNotNull(storageService);
      return this;
    }

    @Override
    public Builder overridesRegistry(OverridesRegistry overridesRegistry) {
      this.overridesRegistry = overridesRegistry;
      return this;
    }

    @Override
    public Builder encryption(EncryptionConfig encryptionConfig) {
      this.encryption = encryptionConfig;
      return this;
    }

    @Override
    public CustomlyBuiltDatasafeServices build() {
      Preconditions.checkBuilderRequirement(config, DFSConfig.class);
      Preconditions.checkBuilderRequirement(storage, StorageService.class);
      return new CustomlyBuiltDatasafeServicesImpl(config, storage, overridesRegistry, encryption);
    }
  }

  private static final class CustomlyBuiltDatasafeServicesImpl implements CustomlyBuiltDatasafeServices {
    private final OverridesRegistry overridesRegistry;

    private final DFSConfig config;

    private final StorageService storage;

    private final EncryptionConfig encryption;

    private final CustomlyBuiltDatasafeServicesImpl customlyBuiltDatasafeServicesImpl = this;

    private Provider<OverridesRegistry> overridesRegistryProvider;

    private Provider<PublicKeySerdeImplRuntimeDelegatable> publicKeySerdeImplRuntimeDelegatableProvider;

    private Provider<GsonSerde> gsonSerdeProvider;

    private Provider<EncryptionConfig> encryptionProvider;

    private Provider<KeyStoreConfig> keyStoreConfigProvider;

    private Provider<Juggler> jugglerProvider;

    private Provider<KeyStoreServiceImplRuntimeDelegatable> keyStoreServiceImplRuntimeDelegatableProvider;

    private Provider<KeyCreationConfig> cmsEncryptionConfigProvider;

    private Provider<DFSConfig> configProvider;

    private Provider<StorageService> storageProvider;

    private Provider<KeyStoreCache> keyStoreCacheProvider;

    private Provider<GenericKeystoreOperations> genericKeystoreOperationsProvider;

    private Provider<StorageKeyStoreOperationsImplRuntimeDelegatable> storageKeyStoreOperationsImplRuntimeDelegatableProvider;

    private Provider<BucketAccessServiceImplRuntimeDelegatable> bucketAccessServiceImplRuntimeDelegatableProvider;

    private Provider<UserProfileCache> userProfileCacheProvider;

    private Provider<ProfileRetrievalServiceImplRuntimeDelegatable> profileRetrievalServiceImplRuntimeDelegatableProvider;

    private CustomlyBuiltDatasafeServicesImpl(DFSConfig configParam, StorageService storageParam,
        OverridesRegistry overridesRegistryParam, EncryptionConfig encryptionParam) {
      this.overridesRegistry = overridesRegistryParam;
      this.config = configParam;
      this.storage = storageParam;
      this.encryption = encryptionParam;
      initialize(configParam, storageParam, overridesRegistryParam, encryptionParam);

    }

    private BucketAccessServiceImplRuntimeDelegatable bucketAccessServiceImplRuntimeDelegatable() {
      return new BucketAccessServiceImplRuntimeDelegatable(overridesRegistry, DoubleCheck.lazy(((Provider) storageKeyStoreOperationsImplRuntimeDelegatableProvider)));
    }

    private PublicKeySerdeImplRuntimeDelegatable publicKeySerdeImplRuntimeDelegatable() {
      return new PublicKeySerdeImplRuntimeDelegatable(overridesRegistry);
    }

    private GsonSerde gsonSerde() {
      return new GsonSerde(publicKeySerdeImplRuntimeDelegatable());
    }

    private ProfileRetrievalServiceImplRuntimeDelegatable profileRetrievalServiceImplRuntimeDelegatable(
        ) {
      return new ProfileRetrievalServiceImplRuntimeDelegatable(overridesRegistry, config, storage, storage, bucketAccessServiceImplRuntimeDelegatable(), gsonSerde(), userProfileCacheProvider.get());
    }

    private ResourceResolverImplRuntimeDelegatable resourceResolverImplRuntimeDelegatable() {
      return new ResourceResolverImplRuntimeDelegatable(overridesRegistry, profileRetrievalServiceImplRuntimeDelegatable(), bucketAccessServiceImplRuntimeDelegatable());
    }

    private EncryptedResourceResolverImplRuntimeDelegatable encryptedResourceResolverImplRuntimeDelegatable(
        ) {
      return new EncryptedResourceResolverImplRuntimeDelegatable(overridesRegistry, bucketAccessServiceImplRuntimeDelegatable(), resourceResolverImplRuntimeDelegatable(), CustomPathEncryptionModule_PathEncryptionFactory.pathEncryption());
    }

    private ListPrivateImplRuntimeDelegatable listPrivateImplRuntimeDelegatable() {
      return new ListPrivateImplRuntimeDelegatable(overridesRegistry, encryptedResourceResolverImplRuntimeDelegatable(), storage);
    }

    private KeyCreationConfig keyCreationConfig() {
      return DefaultProfileModule_CmsEncryptionConfigFactory.cmsEncryptionConfig(encryption);
    }

    private KeyStoreConfig keyStoreConfig() {
      return DefaultKeyStoreModule_KeyStoreConfigFactory.keyStoreConfig(encryption);
    }

    private Juggler juggler() {
      return DefaultKeyStoreModule_JugglerFactory.juggler(keyStoreConfig());
    }

    private KeyStoreServiceImplRuntimeDelegatable keyStoreServiceImplRuntimeDelegatable() {
      return new KeyStoreServiceImplRuntimeDelegatable(overridesRegistry, keyStoreConfig(), juggler());
    }

    private GenericKeystoreOperations genericKeystoreOperations() {
      return new GenericKeystoreOperations(keyCreationConfig(), config, storage, storage, keyStoreCacheProvider.get(), keyStoreServiceImplRuntimeDelegatable());
    }

    private DocumentKeyStoreOperationsImplRuntimeDelegatable documentKeyStoreOperationsImplRuntimeDelegatable(
        ) {
      return new DocumentKeyStoreOperationsImplRuntimeDelegatable(overridesRegistry, keyCreationConfig(), genericKeystoreOperations(), config, bucketAccessServiceImplRuntimeDelegatable(), profileRetrievalServiceImplRuntimeDelegatable(), storage, keyStoreCacheProvider.get(), keyStoreServiceImplRuntimeDelegatable());
    }

    private DFSPrivateKeyServiceImplRuntimeDelegatable dFSPrivateKeyServiceImplRuntimeDelegatable(
        ) {
      return new DFSPrivateKeyServiceImplRuntimeDelegatable(overridesRegistry, documentKeyStoreOperationsImplRuntimeDelegatable());
    }

    private CmsEncryptionConfig cmsEncryptionConfig() {
      return DefaultCMSEncryptionModule_CmsEncryptionConfigFactory.cmsEncryptionConfig(encryption);
    }

    private ASNCmsEncryptionConfig aSNCmsEncryptionConfig() {
      return new ASNCmsEncryptionConfig(cmsEncryptionConfig());
    }

    private CMSEncryptionServiceImplRuntimeDelegatable cMSEncryptionServiceImplRuntimeDelegatable(
        ) {
      return new CMSEncryptionServiceImplRuntimeDelegatable(overridesRegistry, aSNCmsEncryptionConfig());
    }

    private CMSDocumentReadServiceRuntimeDelegatable cMSDocumentReadServiceRuntimeDelegatable() {
      return new CMSDocumentReadServiceRuntimeDelegatable(overridesRegistry, storage, dFSPrivateKeyServiceImplRuntimeDelegatable(), cMSEncryptionServiceImplRuntimeDelegatable());
    }

    private ReadFromPrivateImplRuntimeDelegatable readFromPrivateImplRuntimeDelegatable() {
      return new ReadFromPrivateImplRuntimeDelegatable(overridesRegistry, encryptedResourceResolverImplRuntimeDelegatable(), cMSDocumentReadServiceRuntimeDelegatable());
    }

    private CMSDocumentWriteServiceRuntimeDelegatable cMSDocumentWriteServiceRuntimeDelegatable() {
      return new CMSDocumentWriteServiceRuntimeDelegatable(overridesRegistry, storage, cMSEncryptionServiceImplRuntimeDelegatable());
    }

    private WriteToPrivateImplRuntimeDelegatable writeToPrivateImplRuntimeDelegatable() {
      return new WriteToPrivateImplRuntimeDelegatable(overridesRegistry, dFSPrivateKeyServiceImplRuntimeDelegatable(), encryptedResourceResolverImplRuntimeDelegatable(), cMSDocumentWriteServiceRuntimeDelegatable());
    }

    private RemoveFromPrivateImplRuntimeDelegatable removeFromPrivateImplRuntimeDelegatable() {
      return new RemoveFromPrivateImplRuntimeDelegatable(overridesRegistry, encryptedResourceResolverImplRuntimeDelegatable(), storage);
    }

    private PrivateSpaceServiceImplRuntimeDelegatable privateSpaceServiceImplRuntimeDelegatable() {
      return new PrivateSpaceServiceImplRuntimeDelegatable(overridesRegistry, listPrivateImplRuntimeDelegatable(), readFromPrivateImplRuntimeDelegatable(), writeToPrivateImplRuntimeDelegatable(), removeFromPrivateImplRuntimeDelegatable());
    }

    private ListInboxImplRuntimeDelegatable listInboxImplRuntimeDelegatable() {
      return new ListInboxImplRuntimeDelegatable(overridesRegistry, dFSPrivateKeyServiceImplRuntimeDelegatable(), profileRetrievalServiceImplRuntimeDelegatable(), resourceResolverImplRuntimeDelegatable(), storage);
    }

    private ReadFromInboxImplRuntimeDelegatable readFromInboxImplRuntimeDelegatable() {
      return new ReadFromInboxImplRuntimeDelegatable(overridesRegistry, resourceResolverImplRuntimeDelegatable(), cMSDocumentReadServiceRuntimeDelegatable());
    }

    private DFSPublicKeyServiceImplRuntimeDelegatable dFSPublicKeyServiceImplRuntimeDelegatable() {
      return new DFSPublicKeyServiceImplRuntimeDelegatable(overridesRegistry, keyStoreCacheProvider.get(), bucketAccessServiceImplRuntimeDelegatable(), profileRetrievalServiceImplRuntimeDelegatable(), storage, gsonSerde());
    }

    private WriteToInboxImplRuntimeDelegatable writeToInboxImplRuntimeDelegatable() {
      return new WriteToInboxImplRuntimeDelegatable(overridesRegistry, dFSPublicKeyServiceImplRuntimeDelegatable(), resourceResolverImplRuntimeDelegatable(), cMSDocumentWriteServiceRuntimeDelegatable());
    }

    private RemoveFromInboxImplRuntimeDelegatable removeFromInboxImplRuntimeDelegatable() {
      return new RemoveFromInboxImplRuntimeDelegatable(overridesRegistry, dFSPrivateKeyServiceImplRuntimeDelegatable(), resourceResolverImplRuntimeDelegatable(), storage);
    }

    private InboxServiceImplRuntimeDelegatable inboxServiceImplRuntimeDelegatable() {
      return new InboxServiceImplRuntimeDelegatable(overridesRegistry, listInboxImplRuntimeDelegatable(), readFromInboxImplRuntimeDelegatable(), writeToInboxImplRuntimeDelegatable(), removeFromInboxImplRuntimeDelegatable());
    }

    private ProfileStoreService profileStoreService() {
      return new ProfileStoreService(gsonSerde(), userProfileCacheProvider.get(), config, bucketAccessServiceImplRuntimeDelegatable(), storage);
    }

    private StorageKeyStoreOperationsImplRuntimeDelegatable storageKeyStoreOperationsImplRuntimeDelegatable(
        ) {
      return new StorageKeyStoreOperationsImplRuntimeDelegatable(overridesRegistry, gsonSerde(), keyStoreServiceImplRuntimeDelegatable(), genericKeystoreOperations(), profileRetrievalServiceImplRuntimeDelegatable(), bucketAccessServiceImplRuntimeDelegatable(), keyStoreCacheProvider.get());
    }

    private ProfileRegistrationServiceImplRuntimeDelegatable profileRegistrationServiceImplRuntimeDelegatable(
        ) {
      return new ProfileRegistrationServiceImplRuntimeDelegatable(overridesRegistry, profileStoreService(), storageKeyStoreOperationsImplRuntimeDelegatable(), documentKeyStoreOperationsImplRuntimeDelegatable(), bucketAccessServiceImplRuntimeDelegatable(), storage, storage, gsonSerde(), config);
    }

    private ProfileRemovalServiceImplRuntimeDelegatable profileRemovalServiceImplRuntimeDelegatable(
        ) {
      return new ProfileRemovalServiceImplRuntimeDelegatable(overridesRegistry, dFSPrivateKeyServiceImplRuntimeDelegatable(), keyStoreCacheProvider.get(), userProfileCacheProvider.get(), storage, bucketAccessServiceImplRuntimeDelegatable(), config, storage, profileRetrievalServiceImplRuntimeDelegatable());
    }

    private ProfileUpdatingServiceImplRuntimeDelegatable profileUpdatingServiceImplRuntimeDelegatable(
        ) {
      return new ProfileUpdatingServiceImplRuntimeDelegatable(overridesRegistry, profileStoreService(), dFSPrivateKeyServiceImplRuntimeDelegatable(), storageKeyStoreOperationsImplRuntimeDelegatable(), documentKeyStoreOperationsImplRuntimeDelegatable());
    }

    private ProfileStorageCredentialsServiceImplRuntimeDelegatable profileStorageCredentialsServiceImplRuntimeDelegatable(
        ) {
      return new ProfileStorageCredentialsServiceImplRuntimeDelegatable(overridesRegistry, storageKeyStoreOperationsImplRuntimeDelegatable(), dFSPrivateKeyServiceImplRuntimeDelegatable());
    }

    private DFSBasedProfileStorageImplRuntimeDelegatable dFSBasedProfileStorageImplRuntimeDelegatable(
        ) {
      return new DFSBasedProfileStorageImplRuntimeDelegatable(overridesRegistry, profileRegistrationServiceImplRuntimeDelegatable(), profileRetrievalServiceImplRuntimeDelegatable(), profileRemovalServiceImplRuntimeDelegatable(), profileUpdatingServiceImplRuntimeDelegatable(), profileStorageCredentialsServiceImplRuntimeDelegatable());
    }

    @SuppressWarnings("unchecked")
    private void initialize(final DFSConfig configParam, final StorageService storageParam,
        final OverridesRegistry overridesRegistryParam, final EncryptionConfig encryptionParam) {
      this.overridesRegistryProvider = InstanceFactory.createNullable(overridesRegistryParam);
      this.publicKeySerdeImplRuntimeDelegatableProvider = PublicKeySerdeImplRuntimeDelegatable_Factory.create(overridesRegistryProvider);
      this.gsonSerdeProvider = GsonSerde_Factory.create(((Provider) publicKeySerdeImplRuntimeDelegatableProvider));
      this.encryptionProvider = InstanceFactory.createNullable(encryptionParam);
      this.keyStoreConfigProvider = DefaultKeyStoreModule_KeyStoreConfigFactory.create(encryptionProvider);
      this.jugglerProvider = DefaultKeyStoreModule_JugglerFactory.create(keyStoreConfigProvider);
      this.keyStoreServiceImplRuntimeDelegatableProvider = KeyStoreServiceImplRuntimeDelegatable_Factory.create(overridesRegistryProvider, keyStoreConfigProvider, jugglerProvider);
      this.cmsEncryptionConfigProvider = DefaultProfileModule_CmsEncryptionConfigFactory.create(encryptionProvider);
      this.configProvider = InstanceFactory.create(configParam);
      this.storageProvider = InstanceFactory.create(storageParam);
      this.keyStoreCacheProvider = DoubleCheck.provider(DefaultKeystoreCacheModule_KeyStoreCacheFactory.create(overridesRegistryProvider));
      this.genericKeystoreOperationsProvider = GenericKeystoreOperations_Factory.create(cmsEncryptionConfigProvider, configProvider, ((Provider) storageProvider), ((Provider) storageProvider), keyStoreCacheProvider, ((Provider) keyStoreServiceImplRuntimeDelegatableProvider));
      this.storageKeyStoreOperationsImplRuntimeDelegatableProvider = new DelegateFactory<>();
      this.bucketAccessServiceImplRuntimeDelegatableProvider = BucketAccessServiceImplRuntimeDelegatable_Factory.create(overridesRegistryProvider, ((Provider) storageKeyStoreOperationsImplRuntimeDelegatableProvider));
      this.userProfileCacheProvider = DoubleCheck.provider(DefaultProfileModule_UserProfileCacheFactory.create(overridesRegistryProvider));
      this.profileRetrievalServiceImplRuntimeDelegatableProvider = ProfileRetrievalServiceImplRuntimeDelegatable_Factory.create(overridesRegistryProvider, configProvider, ((Provider) storageProvider), ((Provider) storageProvider), ((Provider) bucketAccessServiceImplRuntimeDelegatableProvider), gsonSerdeProvider, userProfileCacheProvider);
      DelegateFactory.setDelegate(storageKeyStoreOperationsImplRuntimeDelegatableProvider, StorageKeyStoreOperationsImplRuntimeDelegatable_Factory.create(overridesRegistryProvider, gsonSerdeProvider, ((Provider) keyStoreServiceImplRuntimeDelegatableProvider), genericKeystoreOperationsProvider, ((Provider) profileRetrievalServiceImplRuntimeDelegatableProvider), ((Provider) bucketAccessServiceImplRuntimeDelegatableProvider), keyStoreCacheProvider));
    }

    @Override
    public PrivateSpaceService privateService() {
      return privateSpaceServiceImplRuntimeDelegatable();
    }

    @Override
    public InboxService inboxService() {
      return inboxServiceImplRuntimeDelegatable();
    }

    @Override
    public ProfileOperations userProfile() {
      return dFSBasedProfileStorageImplRuntimeDelegatable();
    }
  }
}
