package de.adorsys.datasafe.examples.business.filesystem;

import dagger.internal.DelegateFactory;
import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import de.adorsys.datasafe.business.impl.cmsencryption.DefaultCMSEncryptionModule_CmsEncryptionConfigFactory;
import de.adorsys.datasafe.business.impl.directory.DefaultKeystoreCacheModule_KeyStoreCacheFactory;
import de.adorsys.datasafe.business.impl.directory.DefaultProfileModule_CmsEncryptionConfigFactory;
import de.adorsys.datasafe.business.impl.directory.DefaultProfileModule_UserProfileCacheFactory;
import de.adorsys.datasafe.business.impl.keystore.DefaultKeyStoreModule_JugglerFactory;
import de.adorsys.datasafe.business.impl.keystore.DefaultKeyStoreModule_KeyStoreConfigFactory;
import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileOperations;
import de.adorsys.datasafe.directory.impl.profile.dfs.BucketAccessServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.directory.impl.profile.dfs.BucketAccessServiceImplRuntimeDelegatable_Factory;
import de.adorsys.datasafe.directory.impl.profile.keys.DFSPrivateKeyServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.directory.impl.profile.keys.DFSPublicKeyServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.directory.impl.profile.keys.DocumentKeyStoreOperationsImplRuntimeDelegatable;
import de.adorsys.datasafe.directory.impl.profile.keys.GenericKeystoreOperations;
import de.adorsys.datasafe.directory.impl.profile.keys.GenericKeystoreOperations_Factory;
import de.adorsys.datasafe.directory.impl.profile.keys.KeyStoreCache;
import de.adorsys.datasafe.directory.impl.profile.keys.StorageKeyStoreOperationsImplRuntimeDelegatable;
import de.adorsys.datasafe.directory.impl.profile.keys.StorageKeyStoreOperationsImplRuntimeDelegatable_Factory;
import de.adorsys.datasafe.directory.impl.profile.operations.DFSBasedProfileStorageImplRuntimeDelegatable;
import de.adorsys.datasafe.directory.impl.profile.operations.UserProfileCache;
import de.adorsys.datasafe.directory.impl.profile.operations.actions.ProfileRegistrationServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.directory.impl.profile.operations.actions.ProfileRemovalServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.directory.impl.profile.operations.actions.ProfileRetrievalServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.directory.impl.profile.operations.actions.ProfileRetrievalServiceImplRuntimeDelegatable_Factory;
import de.adorsys.datasafe.directory.impl.profile.operations.actions.ProfileStorageCredentialsServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.directory.impl.profile.operations.actions.ProfileStoreService;
import de.adorsys.datasafe.directory.impl.profile.operations.actions.ProfileUpdatingServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.directory.impl.profile.resource.ResourceResolverImplRuntimeDelegatable;
import de.adorsys.datasafe.directory.impl.profile.serde.GsonSerde;
import de.adorsys.datasafe.directory.impl.profile.serde.GsonSerde_Factory;
import de.adorsys.datasafe.encrypiton.api.types.encryption.CmsEncryptionConfig;
import de.adorsys.datasafe.encrypiton.api.types.encryption.EncryptionConfig;
import de.adorsys.datasafe.encrypiton.api.types.encryption.KeyCreationConfig;
import de.adorsys.datasafe.encrypiton.impl.cmsencryption.ASNCmsEncryptionConfig;
import de.adorsys.datasafe.encrypiton.impl.cmsencryption.CMSEncryptionServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.encrypiton.impl.document.CMSDocumentReadServiceRuntimeDelegatable;
import de.adorsys.datasafe.encrypiton.impl.document.CMSDocumentWriteServiceRuntimeDelegatable;
import de.adorsys.datasafe.encrypiton.impl.keystore.KeyStoreServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.encrypiton.impl.keystore.KeyStoreServiceImplRuntimeDelegatable_Factory;
import de.adorsys.datasafe.encrypiton.impl.keystore.PublicKeySerdeImplRuntimeDelegatable;
import de.adorsys.datasafe.encrypiton.impl.keystore.PublicKeySerdeImplRuntimeDelegatable_Factory;
import de.adorsys.datasafe.inbox.api.InboxService;
import de.adorsys.datasafe.inbox.impl.InboxServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.inbox.impl.actions.ListInboxImplRuntimeDelegatable;
import de.adorsys.datasafe.inbox.impl.actions.ReadFromInboxImplRuntimeDelegatable;
import de.adorsys.datasafe.inbox.impl.actions.RemoveFromInboxImplRuntimeDelegatable;
import de.adorsys.datasafe.inbox.impl.actions.WriteToInboxImplRuntimeDelegatable;
import de.adorsys.datasafe.privatestore.api.PrivateSpaceService;
import de.adorsys.datasafe.privatestore.impl.PrivateSpaceServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.privatestore.impl.actions.EncryptedResourceResolverImplRuntimeDelegatable;
import de.adorsys.datasafe.privatestore.impl.actions.ListPrivateImplRuntimeDelegatable;
import de.adorsys.datasafe.privatestore.impl.actions.ReadFromPrivateImplRuntimeDelegatable;
import de.adorsys.datasafe.privatestore.impl.actions.RemoveFromPrivateImplRuntimeDelegatable;
import de.adorsys.datasafe.privatestore.impl.actions.WriteToPrivateImplRuntimeDelegatable;
import de.adorsys.datasafe.storage.api.StorageService;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import de.adorsys.keymanagement.api.Juggler;
import de.adorsys.keymanagement.api.config.keystore.KeyStoreConfig;
import javax.annotation.Generated;
import javax.inject.Provider;

@Generated(
    value = "dagger.internal.codegen.ComponentProcessor",
    comments = "https://dagger.dev"
)
@SuppressWarnings({
    "unchecked",
    "rawtypes"
})
public final class DaggerCustomlyBuiltDatasafeServices implements CustomlyBuiltDatasafeServices {
  private final OverridesRegistry overridesRegistry;

  private final DFSConfig config;

  private final StorageService storage;

  private final EncryptionConfig encryption;

  private Provider<OverridesRegistry> overridesRegistryProvider;

  private Provider<PublicKeySerdeImplRuntimeDelegatable> publicKeySerdeImplRuntimeDelegatableProvider;

  private Provider<GsonSerde> gsonSerdeProvider;

  private Provider<EncryptionConfig> encryptionProvider;

  private Provider<KeyStoreConfig> keyStoreConfigProvider;

  private Provider<Juggler> jugglerProvider;

  private Provider<KeyStoreServiceImplRuntimeDelegatable> keyStoreServiceImplRuntimeDelegatableProvider;

  private Provider<KeyCreationConfig> cmsEncryptionConfigProvider;

  private Provider<DFSConfig> configProvider;

  private Provider<StorageService> storageProvider;

  private Provider<KeyStoreCache> keyStoreCacheProvider;

  private Provider<GenericKeystoreOperations> genericKeystoreOperationsProvider;

  private Provider<StorageKeyStoreOperationsImplRuntimeDelegatable> storageKeyStoreOperationsImplRuntimeDelegatableProvider;

  private Provider<BucketAccessServiceImplRuntimeDelegatable> bucketAccessServiceImplRuntimeDelegatableProvider;

  private Provider<UserProfileCache> userProfileCacheProvider;

  private Provider<ProfileRetrievalServiceImplRuntimeDelegatable> profileRetrievalServiceImplRuntimeDelegatableProvider;

  private DaggerCustomlyBuiltDatasafeServices(DFSConfig configParam, StorageService storageParam,
      OverridesRegistry overridesRegistryParam, EncryptionConfig encryptionParam) {
    this.overridesRegistry = overridesRegistryParam;
    this.config = configParam;
    this.storage = storageParam;
    this.encryption = encryptionParam;
    initialize(configParam, storageParam, overridesRegistryParam, encryptionParam);
  }

  public static CustomlyBuiltDatasafeServices.Builder builder() {
    return new Builder();
  }

  private BucketAccessServiceImplRuntimeDelegatable getBucketAccessServiceImplRuntimeDelegatable() {
    return new BucketAccessServiceImplRuntimeDelegatable(overridesRegistry, DoubleCheck.lazy((Provider) storageKeyStoreOperationsImplRuntimeDelegatableProvider));}

  private PublicKeySerdeImplRuntimeDelegatable getPublicKeySerdeImplRuntimeDelegatable() {
    return new PublicKeySerdeImplRuntimeDelegatable(overridesRegistry);}

  private GsonSerde getGsonSerde() {
    return new GsonSerde(getPublicKeySerdeImplRuntimeDelegatable());}

  private ProfileRetrievalServiceImplRuntimeDelegatable getProfileRetrievalServiceImplRuntimeDelegatable(
      ) {
    return new ProfileRetrievalServiceImplRuntimeDelegatable(overridesRegistry, config, storage, storage, getBucketAccessServiceImplRuntimeDelegatable(), getGsonSerde(), userProfileCacheProvider.get());}

  private ResourceResolverImplRuntimeDelegatable getResourceResolverImplRuntimeDelegatable() {
    return new ResourceResolverImplRuntimeDelegatable(overridesRegistry, getProfileRetrievalServiceImplRuntimeDelegatable(), getBucketAccessServiceImplRuntimeDelegatable());}

  private EncryptedResourceResolverImplRuntimeDelegatable getEncryptedResourceResolverImplRuntimeDelegatable(
      ) {
    return new EncryptedResourceResolverImplRuntimeDelegatable(overridesRegistry, getBucketAccessServiceImplRuntimeDelegatable(), getResourceResolverImplRuntimeDelegatable(), CustomPathEncryptionModule_PathEncryptionFactory.pathEncryption());}

  private ListPrivateImplRuntimeDelegatable getListPrivateImplRuntimeDelegatable() {
    return new ListPrivateImplRuntimeDelegatable(overridesRegistry, getEncryptedResourceResolverImplRuntimeDelegatable(), storage);}

  private KeyCreationConfig getKeyCreationConfig() {
    return DefaultProfileModule_CmsEncryptionConfigFactory.cmsEncryptionConfig(encryption);}

  private KeyStoreConfig getKeyStoreConfig() {
    return DefaultKeyStoreModule_KeyStoreConfigFactory.keyStoreConfig(encryption);}

  private Juggler getJuggler() {
    return DefaultKeyStoreModule_JugglerFactory.juggler(getKeyStoreConfig());}

  private KeyStoreServiceImplRuntimeDelegatable getKeyStoreServiceImplRuntimeDelegatable() {
    return new KeyStoreServiceImplRuntimeDelegatable(overridesRegistry, getKeyStoreConfig(), getJuggler());}

  private GenericKeystoreOperations getGenericKeystoreOperations() {
    return new GenericKeystoreOperations(getKeyCreationConfig(), config, storage, storage, keyStoreCacheProvider.get(), getKeyStoreServiceImplRuntimeDelegatable());}

  private DocumentKeyStoreOperationsImplRuntimeDelegatable getDocumentKeyStoreOperationsImplRuntimeDelegatable(
      ) {
    return new DocumentKeyStoreOperationsImplRuntimeDelegatable(overridesRegistry, getKeyCreationConfig(), getGenericKeystoreOperations(), config, getBucketAccessServiceImplRuntimeDelegatable(), getProfileRetrievalServiceImplRuntimeDelegatable(), storage, keyStoreCacheProvider.get(), getKeyStoreServiceImplRuntimeDelegatable());}

  private DFSPrivateKeyServiceImplRuntimeDelegatable getDFSPrivateKeyServiceImplRuntimeDelegatable(
      ) {
    return new DFSPrivateKeyServiceImplRuntimeDelegatable(overridesRegistry, getDocumentKeyStoreOperationsImplRuntimeDelegatable());}

  private CmsEncryptionConfig getCmsEncryptionConfig() {
    return DefaultCMSEncryptionModule_CmsEncryptionConfigFactory.cmsEncryptionConfig(encryption);}

  private ASNCmsEncryptionConfig getASNCmsEncryptionConfig() {
    return new ASNCmsEncryptionConfig(getCmsEncryptionConfig());}

  private CMSEncryptionServiceImplRuntimeDelegatable getCMSEncryptionServiceImplRuntimeDelegatable(
      ) {
    return new CMSEncryptionServiceImplRuntimeDelegatable(overridesRegistry, getASNCmsEncryptionConfig());}

  private CMSDocumentReadServiceRuntimeDelegatable getCMSDocumentReadServiceRuntimeDelegatable() {
    return new CMSDocumentReadServiceRuntimeDelegatable(overridesRegistry, storage, getDFSPrivateKeyServiceImplRuntimeDelegatable(), getCMSEncryptionServiceImplRuntimeDelegatable());}

  private ReadFromPrivateImplRuntimeDelegatable getReadFromPrivateImplRuntimeDelegatable() {
    return new ReadFromPrivateImplRuntimeDelegatable(overridesRegistry, getEncryptedResourceResolverImplRuntimeDelegatable(), getCMSDocumentReadServiceRuntimeDelegatable());}

  private CMSDocumentWriteServiceRuntimeDelegatable getCMSDocumentWriteServiceRuntimeDelegatable() {
    return new CMSDocumentWriteServiceRuntimeDelegatable(overridesRegistry, storage, getCMSEncryptionServiceImplRuntimeDelegatable());}

  private WriteToPrivateImplRuntimeDelegatable getWriteToPrivateImplRuntimeDelegatable() {
    return new WriteToPrivateImplRuntimeDelegatable(overridesRegistry, getDFSPrivateKeyServiceImplRuntimeDelegatable(), getEncryptedResourceResolverImplRuntimeDelegatable(), getCMSDocumentWriteServiceRuntimeDelegatable());}

  private RemoveFromPrivateImplRuntimeDelegatable getRemoveFromPrivateImplRuntimeDelegatable() {
    return new RemoveFromPrivateImplRuntimeDelegatable(overridesRegistry, getEncryptedResourceResolverImplRuntimeDelegatable(), storage);}

  private PrivateSpaceServiceImplRuntimeDelegatable getPrivateSpaceServiceImplRuntimeDelegatable() {
    return new PrivateSpaceServiceImplRuntimeDelegatable(overridesRegistry, getListPrivateImplRuntimeDelegatable(), getReadFromPrivateImplRuntimeDelegatable(), getWriteToPrivateImplRuntimeDelegatable(), getRemoveFromPrivateImplRuntimeDelegatable());}

  private ListInboxImplRuntimeDelegatable getListInboxImplRuntimeDelegatable() {
    return new ListInboxImplRuntimeDelegatable(overridesRegistry, getDFSPrivateKeyServiceImplRuntimeDelegatable(), getProfileRetrievalServiceImplRuntimeDelegatable(), getResourceResolverImplRuntimeDelegatable(), storage);}

  private ReadFromInboxImplRuntimeDelegatable getReadFromInboxImplRuntimeDelegatable() {
    return new ReadFromInboxImplRuntimeDelegatable(overridesRegistry, getResourceResolverImplRuntimeDelegatable(), getCMSDocumentReadServiceRuntimeDelegatable());}

  private DFSPublicKeyServiceImplRuntimeDelegatable getDFSPublicKeyServiceImplRuntimeDelegatable() {
    return new DFSPublicKeyServiceImplRuntimeDelegatable(overridesRegistry, keyStoreCacheProvider.get(), getBucketAccessServiceImplRuntimeDelegatable(), getProfileRetrievalServiceImplRuntimeDelegatable(), storage, getGsonSerde());}

  private WriteToInboxImplRuntimeDelegatable getWriteToInboxImplRuntimeDelegatable() {
    return new WriteToInboxImplRuntimeDelegatable(overridesRegistry, getDFSPublicKeyServiceImplRuntimeDelegatable(), getResourceResolverImplRuntimeDelegatable(), getCMSDocumentWriteServiceRuntimeDelegatable());}

  private RemoveFromInboxImplRuntimeDelegatable getRemoveFromInboxImplRuntimeDelegatable() {
    return new RemoveFromInboxImplRuntimeDelegatable(overridesRegistry, getDFSPrivateKeyServiceImplRuntimeDelegatable(), getResourceResolverImplRuntimeDelegatable(), storage);}

  private InboxServiceImplRuntimeDelegatable getInboxServiceImplRuntimeDelegatable() {
    return new InboxServiceImplRuntimeDelegatable(overridesRegistry, getListInboxImplRuntimeDelegatable(), getReadFromInboxImplRuntimeDelegatable(), getWriteToInboxImplRuntimeDelegatable(), getRemoveFromInboxImplRuntimeDelegatable());}

  private ProfileStoreService getProfileStoreService() {
    return new ProfileStoreService(getGsonSerde(), userProfileCacheProvider.get(), config, getBucketAccessServiceImplRuntimeDelegatable(), storage);}

  private StorageKeyStoreOperationsImplRuntimeDelegatable getStorageKeyStoreOperationsImplRuntimeDelegatable(
      ) {
    return new StorageKeyStoreOperationsImplRuntimeDelegatable(overridesRegistry, getGsonSerde(), getKeyStoreServiceImplRuntimeDelegatable(), getGenericKeystoreOperations(), getProfileRetrievalServiceImplRuntimeDelegatable(), getBucketAccessServiceImplRuntimeDelegatable(), keyStoreCacheProvider.get());}

  private ProfileRegistrationServiceImplRuntimeDelegatable getProfileRegistrationServiceImplRuntimeDelegatable(
      ) {
    return new ProfileRegistrationServiceImplRuntimeDelegatable(overridesRegistry, getProfileStoreService(), getStorageKeyStoreOperationsImplRuntimeDelegatable(), getDocumentKeyStoreOperationsImplRuntimeDelegatable(), getBucketAccessServiceImplRuntimeDelegatable(), storage, storage, getGsonSerde(), config);}

  private ProfileRemovalServiceImplRuntimeDelegatable getProfileRemovalServiceImplRuntimeDelegatable(
      ) {
    return new ProfileRemovalServiceImplRuntimeDelegatable(overridesRegistry, getDFSPrivateKeyServiceImplRuntimeDelegatable(), keyStoreCacheProvider.get(), userProfileCacheProvider.get(), storage, getBucketAccessServiceImplRuntimeDelegatable(), config, storage, getProfileRetrievalServiceImplRuntimeDelegatable());}

  private ProfileUpdatingServiceImplRuntimeDelegatable getProfileUpdatingServiceImplRuntimeDelegatable(
      ) {
    return new ProfileUpdatingServiceImplRuntimeDelegatable(overridesRegistry, getProfileStoreService(), getDFSPrivateKeyServiceImplRuntimeDelegatable(), getStorageKeyStoreOperationsImplRuntimeDelegatable(), getDocumentKeyStoreOperationsImplRuntimeDelegatable());}

  private ProfileStorageCredentialsServiceImplRuntimeDelegatable getProfileStorageCredentialsServiceImplRuntimeDelegatable(
      ) {
    return new ProfileStorageCredentialsServiceImplRuntimeDelegatable(overridesRegistry, getStorageKeyStoreOperationsImplRuntimeDelegatable(), getDFSPrivateKeyServiceImplRuntimeDelegatable());}

  private DFSBasedProfileStorageImplRuntimeDelegatable getDFSBasedProfileStorageImplRuntimeDelegatable(
      ) {
    return new DFSBasedProfileStorageImplRuntimeDelegatable(overridesRegistry, getProfileRegistrationServiceImplRuntimeDelegatable(), getProfileRetrievalServiceImplRuntimeDelegatable(), getProfileRemovalServiceImplRuntimeDelegatable(), getProfileUpdatingServiceImplRuntimeDelegatable(), getProfileStorageCredentialsServiceImplRuntimeDelegatable());}

  @SuppressWarnings("unchecked")
  private void initialize(final DFSConfig configParam, final StorageService storageParam,
      final OverridesRegistry overridesRegistryParam, final EncryptionConfig encryptionParam) {
    this.overridesRegistryProvider = InstanceFactory.createNullable(overridesRegistryParam);
    this.publicKeySerdeImplRuntimeDelegatableProvider = PublicKeySerdeImplRuntimeDelegatable_Factory.create(overridesRegistryProvider);
    this.gsonSerdeProvider = GsonSerde_Factory.create((Provider) publicKeySerdeImplRuntimeDelegatableProvider);
    this.encryptionProvider = InstanceFactory.createNullable(encryptionParam);
    this.keyStoreConfigProvider = DefaultKeyStoreModule_KeyStoreConfigFactory.create(encryptionProvider);
    this.jugglerProvider = DefaultKeyStoreModule_JugglerFactory.create(keyStoreConfigProvider);
    this.keyStoreServiceImplRuntimeDelegatableProvider = KeyStoreServiceImplRuntimeDelegatable_Factory.create(overridesRegistryProvider, keyStoreConfigProvider, jugglerProvider);
    this.cmsEncryptionConfigProvider = DefaultProfileModule_CmsEncryptionConfigFactory.create(encryptionProvider);
    this.configProvider = InstanceFactory.create(configParam);
    this.storageProvider = InstanceFactory.create(storageParam);
    this.keyStoreCacheProvider = DoubleCheck.provider(DefaultKeystoreCacheModule_KeyStoreCacheFactory.create(overridesRegistryProvider));
    this.genericKeystoreOperationsProvider = GenericKeystoreOperations_Factory.create(cmsEncryptionConfigProvider, configProvider, (Provider) storageProvider, (Provider) storageProvider, keyStoreCacheProvider, (Provider) keyStoreServiceImplRuntimeDelegatableProvider);
    this.storageKeyStoreOperationsImplRuntimeDelegatableProvider = new DelegateFactory<>();
    this.bucketAccessServiceImplRuntimeDelegatableProvider = BucketAccessServiceImplRuntimeDelegatable_Factory.create(overridesRegistryProvider, (Provider) storageKeyStoreOperationsImplRuntimeDelegatableProvider);
    this.userProfileCacheProvider = DoubleCheck.provider(DefaultProfileModule_UserProfileCacheFactory.create(overridesRegistryProvider));
    this.profileRetrievalServiceImplRuntimeDelegatableProvider = ProfileRetrievalServiceImplRuntimeDelegatable_Factory.create(overridesRegistryProvider, configProvider, (Provider) storageProvider, (Provider) storageProvider, (Provider) bucketAccessServiceImplRuntimeDelegatableProvider, gsonSerdeProvider, userProfileCacheProvider);
    DelegateFactory.setDelegate(storageKeyStoreOperationsImplRuntimeDelegatableProvider, StorageKeyStoreOperationsImplRuntimeDelegatable_Factory.create(overridesRegistryProvider, gsonSerdeProvider, (Provider) keyStoreServiceImplRuntimeDelegatableProvider, genericKeystoreOperationsProvider, (Provider) profileRetrievalServiceImplRuntimeDelegatableProvider, (Provider) bucketAccessServiceImplRuntimeDelegatableProvider, keyStoreCacheProvider));
  }

  @Override
  public PrivateSpaceService privateService() {
    return getPrivateSpaceServiceImplRuntimeDelegatable();}

  @Override
  public InboxService inboxService() {
    return getInboxServiceImplRuntimeDelegatable();}

  @Override
  public ProfileOperations userProfile() {
    return getDFSBasedProfileStorageImplRuntimeDelegatable();}

  private static final class Builder implements CustomlyBuiltDatasafeServices.Builder {
    private DFSConfig config;

    private StorageService storage;

    private OverridesRegistry overridesRegistry;

    private EncryptionConfig encryption;

    @Override
    public Builder config(DFSConfig config) {
      this.config = Preconditions.checkNotNull(config);
      return this;
    }

    @Override
    public Builder storage(StorageService storageService) {
      this.storage = Preconditions.checkNotNull(storageService);
      return this;
    }

    @Override
    public Builder overridesRegistry(OverridesRegistry overridesRegistry) {
      this.overridesRegistry = overridesRegistry;
      return this;
    }

    @Override
    public Builder encryption(EncryptionConfig encryptionConfig) {
      this.encryption = encryptionConfig;
      return this;
    }

    @Override
    public CustomlyBuiltDatasafeServices build() {
      Preconditions.checkBuilderRequirement(config, DFSConfig.class);
      Preconditions.checkBuilderRequirement(storage, StorageService.class);
      return new DaggerCustomlyBuiltDatasafeServices(config, storage, overridesRegistry, encryption);
    }
  }
}
