package de.adorsys.datasafe.encrypiton.impl.pathencryption;

import de.adorsys.datasafe.encrypiton.api.types.keystore.AuthPathEncryptionSecretKey;
import de.adorsys.datasafe.encrypiton.impl.pathencryption.dto.PathSegmentWithSecretKeyWith;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import de.adorsys.datasafe.types.api.resource.Uri;
import java.lang.Override;
import java.lang.String;
import java.security.MessageDigest;
import java.util.function.Function;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Generated(
        value = "de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator",
        comments = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used."
)
public class IntegrityPreservingUriEncryptionRuntimeDelegatable extends IntegrityPreservingUriEncryption {
    private final IntegrityPreservingUriEncryption delegate;

    /**
     * @param context Context class to search for overrides.
     */
    @Inject
    public IntegrityPreservingUriEncryptionRuntimeDelegatable(@Nullable OverridesRegistry context,
            PathEncryptorDecryptor pathEncryptorDecryptor) {
        super(pathEncryptorDecryptor);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(pathEncryptorDecryptor);
        delegate = context != null ? context.findOverride(IntegrityPreservingUriEncryption.class, argumentsCaptor) : null;
    }

    @Override
    public Uri encrypt(AuthPathEncryptionSecretKey pathEncryptionSecretKey, Uri bucketPath) {
        if (null == delegate) {
            return super.encrypt(pathEncryptionSecretKey, bucketPath);
        } else {
            return delegate.encrypt(pathEncryptionSecretKey, bucketPath);
        }
    }

    @Override
    public Uri decrypt(AuthPathEncryptionSecretKey pathEncryptionSecretKey, Uri bucketPath) {
        if (null == delegate) {
            return super.decrypt(pathEncryptionSecretKey, bucketPath);
        } else {
            return delegate.decrypt(pathEncryptionSecretKey, bucketPath);
        }
    }

    @Override
    protected MessageDigest getDigest() {
        if (null == delegate) {
            return super.getDigest();
        } else {
            return delegate.getDigest();
        }
    }

    @Override
    protected String decryptorAndDecoder(PathSegmentWithSecretKeyWith keyAndSegment,
            PathEncryptorDecryptor pathEncryptorDecryptor) {
        if (null == delegate) {
            return super.decryptorAndDecoder(keyAndSegment, pathEncryptorDecryptor);
        } else {
            return delegate.decryptorAndDecoder(keyAndSegment, pathEncryptorDecryptor);
        }
    }

    @Override
    protected String encryptorAndEncoder(PathSegmentWithSecretKeyWith keyAndSegment,
            PathEncryptorDecryptor pathEncryptorDecryptor) {
        if (null == delegate) {
            return super.encryptorAndEncoder(keyAndSegment, pathEncryptorDecryptor);
        } else {
            return delegate.encryptorAndEncoder(keyAndSegment, pathEncryptorDecryptor);
        }
    }

    /**
     * This is a typesafe function to register overriding class into context.
     */
    public static void overrideWith(OverridesRegistry context,
            Function<ArgumentsCaptor, IntegrityPreservingUriEncryption> ctorCaptor) {
        context.override(IntegrityPreservingUriEncryption.class, args -> ctorCaptor.apply((ArgumentsCaptor) args));
    }

    public static class ArgumentsCaptor {
        private final PathEncryptorDecryptor pathEncryptorDecryptor;

        private ArgumentsCaptor(PathEncryptorDecryptor pathEncryptorDecryptor) {
            this.pathEncryptorDecryptor = pathEncryptorDecryptor;
        }

        public PathEncryptorDecryptor getPathEncryptorDecryptor() {
            return pathEncryptorDecryptor;
        }
    }
}
