package de.adorsys.datasafe.encrypiton.impl.keystore;

import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import java.lang.Override;
import java.lang.String;
import java.security.PublicKey;
import java.util.function.Function;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Generated(
        value = "de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator",
        comments = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used."
)
public class PublicKeySerdeImplRuntimeDelegatable extends PublicKeySerdeImpl {
    private final PublicKeySerdeImpl delegate;

    /**
     * @param context Context class to search for overrides.
     */
    @Inject
    public PublicKeySerdeImplRuntimeDelegatable(@Nullable OverridesRegistry context) {
        super();
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor();
        delegate = context != null ? context.findOverride(PublicKeySerdeImpl.class, argumentsCaptor) : null;
    }

    @Override
    public PublicKey readPubKey(String encoded) {
        if (null == delegate) {
            return super.readPubKey(encoded);
        } else {
            return delegate.readPubKey(encoded);
        }
    }

    @Override
    public String writePubKey(PublicKey publicKey) {
        if (null == delegate) {
            return super.writePubKey(publicKey);
        } else {
            return delegate.writePubKey(publicKey);
        }
    }

    /**
     * This is a typesafe function to register overriding class into context.
     */
    public static void overrideWith(OverridesRegistry context,
            Function<ArgumentsCaptor, PublicKeySerdeImpl> ctorCaptor) {
        context.override(PublicKeySerdeImpl.class, args -> ctorCaptor.apply((ArgumentsCaptor) args));
    }

    public static class ArgumentsCaptor {
        private ArgumentsCaptor() {
        }
    }
}
