package de.adorsys.datasafe.encrypiton.impl.cmsencryption;

import de.adorsys.datasafe.encrypiton.api.types.encryption.CmsEncryptionConfig;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import java.lang.Override;
import java.util.function.Function;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;

@Generated(
        value = "de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator",
        comments = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used."
)
public class ASNCmsEncryptionConfigRuntimeDelegatable extends ASNCmsEncryptionConfig {
    private final ASNCmsEncryptionConfig delegate;

    /**
     * @param context Context class to search for overrides.
     */
    @Inject
    public ASNCmsEncryptionConfigRuntimeDelegatable(@Nullable OverridesRegistry context,
            CmsEncryptionConfig cmsEncryptionConfig) {
        super(cmsEncryptionConfig);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(cmsEncryptionConfig);
        delegate = context != null ? context.findOverride(ASNCmsEncryptionConfig.class, argumentsCaptor) : null;
    }

    @Override
    public ASN1ObjectIdentifier getAlgorithm() {
        if (null == delegate) {
            return super.getAlgorithm();
        } else {
            return delegate.getAlgorithm();
        }
    }

    /**
     * This is a typesafe function to register overriding class into context.
     */
    public static void overrideWith(OverridesRegistry context,
            Function<ArgumentsCaptor, ASNCmsEncryptionConfig> ctorCaptor) {
        context.override(ASNCmsEncryptionConfig.class, args -> ctorCaptor.apply((ArgumentsCaptor) args));
    }

    public static class ArgumentsCaptor {
        private final CmsEncryptionConfig cmsEncryptionConfig;

        private ArgumentsCaptor(CmsEncryptionConfig cmsEncryptionConfig) {
            this.cmsEncryptionConfig = cmsEncryptionConfig;
        }

        public CmsEncryptionConfig getCmsEncryptionConfig() {
            return cmsEncryptionConfig;
        }
    }
}
