package de.adorsys.datasafe.encrypiton.impl.pathencryption;

import de.adorsys.datasafe.encrypiton.api.types.keystore.AuthPathEncryptionSecretKey;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import java.lang.Override;
import java.util.function.Function;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.cryptomator.siv.SivMode;

@Generated(
        value = "de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator",
        comments = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used."
)
public class PathSegmentEncryptorDecryptorRuntimeDelegatable extends PathSegmentEncryptorDecryptor {
    private final PathSegmentEncryptorDecryptor delegate;

    /**
     * @param context Context class to search for overrides.
     */
    @Inject
    public PathSegmentEncryptorDecryptorRuntimeDelegatable(@Nullable OverridesRegistry context,
            SivMode sivMode) {
        super(sivMode);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(sivMode);
        delegate = context != null ? context.findOverride(PathSegmentEncryptorDecryptor.class, argumentsCaptor) : null;
    }

    @Override
    public byte[] encrypt(AuthPathEncryptionSecretKey pathSecretKey, byte[] originalPath,
            byte[] associated) {
        if (null == delegate) {
            return super.encrypt(pathSecretKey, originalPath, associated);
        } else {
            return delegate.encrypt(pathSecretKey, originalPath, associated);
        }
    }

    @Override
    public byte[] decrypt(AuthPathEncryptionSecretKey pathSecretKey, byte[] encryptedPath,
            byte[] associated) {
        if (null == delegate) {
            return super.decrypt(pathSecretKey, encryptedPath, associated);
        } else {
            return delegate.decrypt(pathSecretKey, encryptedPath, associated);
        }
    }

    /**
     * This is a typesafe function to register overriding class into context.
     */
    public static void overrideWith(OverridesRegistry context,
            Function<ArgumentsCaptor, PathSegmentEncryptorDecryptor> ctorCaptor) {
        context.override(PathSegmentEncryptorDecryptor.class, args -> ctorCaptor.apply((ArgumentsCaptor) args));
    }

    public static class ArgumentsCaptor {
        private final SivMode sivMode;

        private ArgumentsCaptor(SivMode sivMode) {
            this.sivMode = sivMode;
        }

        public SivMode getSivMode() {
            return sivMode;
        }
    }
}
