package de.adorsys.datasafe.encrypiton.impl.pathencryption;

import de.adorsys.datasafe.directory.api.profile.keys.PrivateKeyService;
import de.adorsys.datasafe.encrypiton.api.pathencryption.encryption.SymmetricPathEncryptionService;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import de.adorsys.datasafe.types.api.resource.Uri;
import java.lang.Override;
import java.util.function.Function;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Generated(
        value = "de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator",
        comments = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used."
)
public class PathEncryptionImplRuntimeDelegatable extends PathEncryptionImpl {
    private final PathEncryptionImpl delegate;

    /**
     * @param context Context class to search for overrides.
     */
    @Inject
    public PathEncryptionImplRuntimeDelegatable(@Nullable OverridesRegistry context,
            SymmetricPathEncryptionService symmetricPathEncryptionService,
            PrivateKeyService privateKeyService) {
        super(symmetricPathEncryptionService, privateKeyService);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(symmetricPathEncryptionService, privateKeyService);
        delegate = context != null ? context.findOverride(PathEncryptionImpl.class, argumentsCaptor) : null;
    }

    @Override
    public Uri encrypt(UserIDAuth forUser, Uri path) {
        if (null == delegate) {
            return super.encrypt(forUser, path);
        } else {
            return delegate.encrypt(forUser, path);
        }
    }

    @Override
    public Function<Uri, Uri> decryptor(UserIDAuth forUser) {
        if (null == delegate) {
            return super.decryptor(forUser);
        } else {
            return delegate.decryptor(forUser);
        }
    }

    /**
     * This is a typesafe function to register overriding class into context.
     */
    public static void overrideWith(OverridesRegistry context,
            Function<ArgumentsCaptor, PathEncryptionImpl> ctorCaptor) {
        context.override(PathEncryptionImpl.class, args -> ctorCaptor.apply((ArgumentsCaptor) args));
    }

    public static class ArgumentsCaptor {
        private final SymmetricPathEncryptionService symmetricPathEncryptionService;

        private final PrivateKeyService privateKeyService;

        private ArgumentsCaptor(SymmetricPathEncryptionService symmetricPathEncryptionService,
                PrivateKeyService privateKeyService) {
            this.symmetricPathEncryptionService = symmetricPathEncryptionService;
            this.privateKeyService = privateKeyService;
        }

        public SymmetricPathEncryptionService getSymmetricPathEncryptionService() {
            return symmetricPathEncryptionService;
        }

        public PrivateKeyService getPrivateKeyService() {
            return privateKeyService;
        }
    }
}
