package de.adorsys.datasafe.encrypiton.impl.document;

import de.adorsys.datasafe.directory.api.profile.keys.PrivateKeyService;
import de.adorsys.datasafe.encrypiton.api.cmsencryption.CMSEncryptionService;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.storage.api.actions.StorageReadService;
import de.adorsys.datasafe.types.api.actions.ReadRequest;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import java.io.InputStream;
import java.lang.Override;
import java.util.function.Function;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Generated(
        value = "de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator",
        comments = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used."
)
public class CMSDocumentReadServiceRuntimeDelegatable extends CMSDocumentReadService {
    private final CMSDocumentReadService delegate;

    /**
     * @param context Context class to search for overrides.
     */
    @Inject
    public CMSDocumentReadServiceRuntimeDelegatable(@Nullable OverridesRegistry context,
            StorageReadService readService, PrivateKeyService privateKeyService,
            CMSEncryptionService cms) {
        super(readService, privateKeyService, cms);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(readService, privateKeyService, cms);
        delegate = context != null ? context.findOverride(CMSDocumentReadService.class, argumentsCaptor) : null;
    }

    @Override
    public InputStream read(ReadRequest<UserIDAuth, AbsoluteLocation<PrivateResource>> request) {
        if (null == delegate) {
            return super.read(request);
        } else {
            return delegate.read(request);
        }
    }

    /**
     * This is a typesafe function to register overriding class into context.
     */
    public static void overrideWith(OverridesRegistry context,
            Function<ArgumentsCaptor, CMSDocumentReadService> ctorCaptor) {
        context.override(CMSDocumentReadService.class, args -> ctorCaptor.apply((ArgumentsCaptor) args));
    }

    public static class ArgumentsCaptor {
        private final StorageReadService readService;

        private final PrivateKeyService privateKeyService;

        private final CMSEncryptionService cms;

        private ArgumentsCaptor(StorageReadService readService, PrivateKeyService privateKeyService,
                CMSEncryptionService cms) {
            this.readService = readService;
            this.privateKeyService = privateKeyService;
            this.cms = cms;
        }

        public StorageReadService getReadService() {
            return readService;
        }

        public PrivateKeyService getPrivateKeyService() {
            return privateKeyService;
        }

        public CMSEncryptionService getCms() {
            return cms;
        }
    }
}
