/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.encrypiton.impl.keystore;

import com.google.common.collect.ImmutableMap;
import de.adorsys.datasafe.encrypiton.api.keystore.KeyStoreService;
import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyID;
import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyStoreAccess;
import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyStoreAuth;
import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyStoreCreationConfig;
import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyStoreType;
import de.adorsys.datasafe.encrypiton.api.types.keystore.PublicKeyIDWithPublicKey;
import de.adorsys.datasafe.encrypiton.api.types.keystore.ReadKeyPassword;
import de.adorsys.datasafe.encrypiton.api.types.keystore.ReadStorePassword;
import de.adorsys.datasafe.encrypiton.api.types.keystore.SecretKeyEntry;
import de.adorsys.datasafe.encrypiton.impl.keystore.KeyStoreGenerator;
import de.adorsys.datasafe.encrypiton.impl.keystore.generator.KeyStoreServiceImplBaseFunctions;
import de.adorsys.datasafe.encrypiton.impl.keystore.types.PasswordBasedKeyConfig;
import de.adorsys.datasafe.types.api.context.annotations.RuntimeDelegate;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RuntimeDelegate
public class KeyStoreServiceImpl
implements KeyStoreService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KeyStoreServiceImpl.class);
    private final PasswordBasedKeyConfig passwordBasedKeyConfig;

    @Inject
    public KeyStoreServiceImpl(PasswordBasedKeyConfig passwordBasedKeyConfig) {
        this.passwordBasedKeyConfig = passwordBasedKeyConfig;
    }

    public KeyStore createKeyStore(KeyStoreAuth keyStoreAuth, KeyStoreType keyStoreType, KeyStoreCreationConfig config) {
        return this.createKeyStore(keyStoreAuth, keyStoreType, config, (Map<KeyID, Optional<SecretKeyEntry>>)ImmutableMap.of((Object)new KeyID("PATH_SECRET" + UUID.randomUUID().toString()), Optional.empty(), (Object)new KeyID("PRIVATE_SECRET" + UUID.randomUUID().toString()), Optional.empty()));
    }

    public KeyStore createKeyStore(KeyStoreAuth keyStoreAuth, KeyStoreType keyStoreType, KeyStoreCreationConfig config, Map<KeyID, Optional<SecretKeyEntry>> secretKeys) {
        log.debug("start create keystore ");
        if (config == null) {
            config = new KeyStoreCreationConfig(5, 5);
        }
        String serverKeyPairAliasPrefix = UUID.randomUUID().toString();
        log.debug("keystoreid = {}", (Object)serverKeyPairAliasPrefix);
        KeyStoreGenerator keyStoreGenerator = KeyStoreGenerator.builder().config(config).keyStoreType(keyStoreType).serverKeyPairAliasPrefix(serverKeyPairAliasPrefix).readKeyPassword(keyStoreAuth.getReadKeyPassword()).secretKeys(secretKeys).build();
        KeyStore userKeyStore = keyStoreGenerator.generate();
        log.debug("finished create keystore ");
        return userKeyStore;
    }

    public KeyStore updateKeyStoreReadKeyPassword(KeyStore current, KeyStoreAuth currentCredentials, KeyStoreAuth newCredentials) {
        KeyStore newKeystore = KeyStore.getInstance(current.getType());
        newKeystore.load(null, null);
        Enumeration<String> aliases = current.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            Key currentKey = current.getKey(alias, currentCredentials.getReadKeyPassword().getValue().toCharArray());
            newKeystore.setKeyEntry(alias, currentKey, newCredentials.getReadKeyPassword().getValue().toCharArray(), current.getCertificateChain(alias));
        }
        return newKeystore;
    }

    public List<PublicKeyIDWithPublicKey> getPublicKeys(KeyStoreAccess keyStoreAccess) {
        log.debug("get public keys");
        ArrayList<PublicKeyIDWithPublicKey> result = new ArrayList<PublicKeyIDWithPublicKey>();
        KeyStore keyStore = keyStoreAccess.getKeyStore();
        Enumeration<String> keyAliases = keyStore.aliases();
        while (keyAliases.hasMoreElements()) {
            boolean[] keyUsage;
            String keyAlias = keyAliases.nextElement();
            X509Certificate cert = (X509Certificate)keyStore.getCertificate(keyAlias);
            if (cert == null || !(keyUsage = cert.getKeyUsage())[2] && !keyUsage[3] && !keyUsage[4]) continue;
            result.add(new PublicKeyIDWithPublicKey(new KeyID(keyAlias), cert.getPublicKey()));
        }
        return result;
    }

    public PrivateKey getPrivateKey(KeyStoreAccess keyStoreAccess, KeyID keyID) {
        ReadKeyPassword readKeyPassword = keyStoreAccess.getKeyStoreAuth().getReadKeyPassword();
        KeyStore keyStore = keyStoreAccess.getKeyStore();
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(keyID.getValue(), readKeyPassword.getValue().toCharArray());
        return privateKey;
    }

    public SecretKeySpec getSecretKey(KeyStoreAccess keyStoreAccess, KeyID keyID) {
        KeyStore keyStore = keyStoreAccess.getKeyStore();
        char[] password = keyStoreAccess.getKeyStoreAuth().getReadKeyPassword().getValue().toCharArray();
        return (SecretKeySpec)keyStore.getKey(keyID.getValue(), password);
    }

    public void addPasswordBasedSecretKey(KeyStoreAccess keyStoreAccess, String alias, char[] secret) {
        PBEKeySpec pbeKeySpec = new PBEKeySpec(secret);
        SecretKeyFactory keyFac = SecretKeyFactory.getInstance(this.passwordBasedKeyConfig.secretKeyFactoryId());
        SecretKey key = keyFac.generateSecret(pbeKeySpec);
        keyStoreAccess.getKeyStore().setKeyEntry(alias, key, keyStoreAccess.getKeyStoreAuth().getReadKeyPassword().getValue().toCharArray(), new Certificate[0]);
    }

    public void removeKey(KeyStoreAccess keyStoreAccess, String alias) {
        keyStoreAccess.getKeyStore().deleteEntry(alias);
    }

    public byte[] serialize(KeyStore store, String storeId, ReadStorePassword readStorePassword) {
        return KeyStoreServiceImplBaseFunctions.toByteArray(store, storeId, readStorePassword);
    }

    public KeyStore deserialize(byte[] payload, String storeId, ReadStorePassword readStorePassword) {
        return KeyStoreServiceImplBaseFunctions.loadKeyStore(payload, storeId, KeyStoreType.DEFAULT, readStorePassword);
    }
}

