/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.encrypiton.impl.document;

import com.google.common.collect.ImmutableList;
import de.adorsys.datasafe.directory.api.profile.keys.PrivateKeyService;
import de.adorsys.datasafe.encrypiton.api.cmsencryption.CMSEncryptionService;
import de.adorsys.datasafe.encrypiton.api.document.EncryptedDocumentReadService;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.storage.api.actions.StorageReadService;
import de.adorsys.datasafe.types.api.actions.ReadRequest;
import de.adorsys.datasafe.types.api.context.annotations.RuntimeDelegate;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.inject.Inject;
import lombok.Generated;

@RuntimeDelegate
public class CMSDocumentReadService
implements EncryptedDocumentReadService {
    private final StorageReadService readService;
    private final PrivateKeyService privateKeyService;
    private final CMSEncryptionService cms;

    @Inject
    public CMSDocumentReadService(StorageReadService readService, PrivateKeyService privateKeyService, CMSEncryptionService cms) {
        this.readService = readService;
        this.privateKeyService = privateKeyService;
        this.cms = cms;
    }

    public InputStream read(ReadRequest<UserIDAuth, AbsoluteLocation<PrivateResource>> request) {
        InputStream dfsSource = this.readService.read((AbsoluteLocation)request.getLocation());
        InputStream encryptionSource = this.cms.buildDecryptionInputStream(dfsSource, keyId -> this.privateKeyService.keysByIds((UserIDAuth)request.getOwner(), keyId));
        return new CloseCoordinatingStream(encryptionSource, (List<InputStream>)ImmutableList.of((Object)encryptionSource, (Object)dfsSource));
    }

    private static final class CloseCoordinatingStream
    extends InputStream {
        private final InputStream streamToRead;
        private final List<InputStream> streamsToClose;

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.streamToRead.read(b, off, len);
        }

        @Override
        public int read() throws IOException {
            return this.streamToRead.read();
        }

        @Override
        public void close() {
            super.close();
            this.streamsToClose.forEach(CloseCoordinatingStream::doClose);
        }

        private static void doClose(InputStream stream) {
            stream.close();
        }

        @Generated
        public CloseCoordinatingStream(InputStream streamToRead, List<InputStream> streamsToClose) {
            this.streamToRead = streamToRead;
            this.streamsToClose = streamsToClose;
        }
    }
}

