/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.encrypiton.impl.keystore.generator;

import de.adorsys.datasafe.encrypiton.impl.keystore.generator.BatchValidator;
import de.adorsys.datasafe.encrypiton.impl.keystore.generator.KeyValue;
import de.adorsys.datasafe.encrypiton.impl.keystore.generator.ListOfKeyValueBuilder;
import de.adorsys.datasafe.encrypiton.impl.keystore.generator.ProviderUtils;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.List;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class SecretKeyBuilder {
    private static Provider provider = ProviderUtils.bcProvider;
    private Integer keyLength;
    private String keyAlg;
    boolean dirty = false;

    public SecretKey build() {
        KeyGenerator kGen;
        if (this.dirty) {
            throw new IllegalStateException("Builder can not be reused");
        }
        this.dirty = true;
        List<KeyValue> notNullCheckList = ListOfKeyValueBuilder.newBuilder().add("keyAlg", this.keyAlg).add("keyLength", this.keyLength).build();
        List<String> nullList = BatchValidator.filterNull(notNullCheckList);
        if (nullList != null && !nullList.isEmpty()) {
            throw new IllegalArgumentException("Fields can not be null: " + nullList);
        }
        try {
            kGen = KeyGenerator.getInstance(this.keyAlg, provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        kGen.init(this.keyLength);
        return kGen.generateKey();
    }

    public SecretKeyBuilder withKeyLength(Integer keyLength) {
        this.keyLength = keyLength;
        return this;
    }

    public SecretKeyBuilder withKeyAlg(String keyAlg) {
        this.keyAlg = keyAlg;
        return this;
    }
}

