/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.encrypiton.impl.keystore.generator;

import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyEntry;
import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyStoreType;
import de.adorsys.datasafe.encrypiton.impl.keystore.generator.KeyStoreServiceImplBaseFunctions;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;

public class KeystoreBuilder {
    private KeyStoreType storeType;
    private Map<String, KeyEntry> keyEntries = new HashMap<String, KeyEntry>();

    public KeystoreBuilder withStoreType(KeyStoreType storeType) {
        this.storeType = storeType;
        return this;
    }

    public KeystoreBuilder withKeyEntry(KeyEntry keyEntry) {
        this.keyEntries.put(keyEntry.getAlias(), keyEntry);
        return this;
    }

    public KeyStore build() {
        KeyStore ks = KeyStoreServiceImplBaseFunctions.newKeyStore(this.storeType);
        KeyStoreServiceImplBaseFunctions.fillKeyStore(ks, this.keyEntries.values());
        return ks;
    }
}

