/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.encrypiton.impl.keystore.generator;

import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyEntry;
import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyStoreType;
import de.adorsys.datasafe.encrypiton.api.types.keystore.ReadKeyPassword;
import de.adorsys.datasafe.encrypiton.api.types.keystore.ReadStorePassword;
import de.adorsys.datasafe.encrypiton.api.types.keystore.SecretKeyEntry;
import de.adorsys.datasafe.encrypiton.impl.keystore.generator.V3CertificateUtils;
import de.adorsys.datasafe.encrypiton.impl.keystore.types.KeyPairEntry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import org.bouncycastle.cert.X509CertificateHolder;

public class KeyStoreServiceImplBaseFunctions {
    private KeyStoreServiceImplBaseFunctions() {
        throw new IllegalStateException("Not supported");
    }

    public static KeyStore newKeyStore(KeyStoreType keyStoreType) {
        KeyStore ks = KeyStore.getInstance(keyStoreType.getValue());
        ks.load(null, null);
        return ks;
    }

    public static byte[] toByteArray(KeyStore keystore, String storeId, ReadStorePassword readStorePassword) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        keystore.store(stream, readStorePassword.getValue().toCharArray());
        return stream.toByteArray();
    }

    public static KeyStore loadKeyStore(InputStream in, String storeId, KeyStoreType storeType, ReadStorePassword readStorePassword) {
        if (storeType == null) {
            storeType = KeyStoreType.DEFAULT;
        }
        KeyStore ks = KeyStore.getInstance(storeType.getValue());
        ks.load(in, readStorePassword.getValue().toCharArray());
        return ks;
    }

    public static KeyStore loadKeyStore(byte[] data, String storeId, KeyStoreType keyStoreType, ReadStorePassword readStorePassword) {
        return KeyStoreServiceImplBaseFunctions.loadKeyStore(new ByteArrayInputStream(data), storeId, keyStoreType, readStorePassword);
    }

    public static void fillKeyStore(KeyStore ks, Collection<KeyEntry> keyEntries) {
        for (KeyEntry keyEntry : keyEntries) {
            KeyStoreServiceImplBaseFunctions.addToKeyStore(ks, keyEntry);
        }
    }

    public static void addToKeyStore(KeyStore ks, KeyEntry keyEntry) {
        if (keyEntry instanceof KeyPairEntry) {
            KeyStoreServiceImplBaseFunctions.addToKeyStore(ks, (KeyPairEntry)keyEntry);
        } else if (keyEntry instanceof SecretKeyEntry) {
            KeyStoreServiceImplBaseFunctions.addToKeyStore(ks, (SecretKeyEntry)keyEntry);
        }
    }

    private static void addToKeyStore(KeyStore ks, KeyPairEntry keyPairHolder) {
        ArrayList<X509Certificate> chainList = new ArrayList<X509Certificate>();
        X509CertificateHolder subjectCert = keyPairHolder.getKeyPair().getSubjectCert();
        chainList.add(V3CertificateUtils.getX509JavaCertificate(subjectCert));
        Certificate[] chain = chainList.toArray(new Certificate[chainList.size()]);
        ks.setKeyEntry(keyPairHolder.getAlias(), keyPairHolder.getKeyPair().getKeyPair().getPrivate(), keyPairHolder.getReadKeyPassword().getValue().toCharArray(), chain);
    }

    public static void addToKeyStore(KeyStore ks, SecretKeyEntry secretKeyData) {
        KeyStore.SecretKeyEntry entry = new KeyStore.SecretKeyEntry(secretKeyData.getSecretKey());
        KeyStore.ProtectionParameter protParam = KeyStoreServiceImplBaseFunctions.getPasswordProtectionParameter(secretKeyData.getReadKeyPassword());
        ks.setEntry(secretKeyData.getAlias(), entry, protParam);
    }

    private static KeyStore.ProtectionParameter getPasswordProtectionParameter(ReadKeyPassword readKeyPassword) {
        return new KeyStore.PasswordProtection(readKeyPassword.getValue().toCharArray());
    }
}

