/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.encrypiton.impl.keystore;

import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyID;
import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyStoreAccess;
import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyStoreAuth;
import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyStoreCreationConfig;
import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyStoreType;
import de.adorsys.datasafe.encrypiton.api.types.keystore.PublicKeyIDWithPublicKey;
import de.adorsys.datasafe.encrypiton.api.types.keystore.ReadStorePassword;
import de.adorsys.datasafe.encrypiton.api.types.keystore.SecretKeyEntry;
import de.adorsys.datasafe.encrypiton.impl.keystore.KeyStoreServiceImpl;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.crypto.spec.SecretKeySpec;
import javax.inject.Inject;

public class KeyStoreServiceImplRuntimeDelegatable
extends KeyStoreServiceImpl {
    private final KeyStoreServiceImpl delegate;

    @Inject
    public KeyStoreServiceImplRuntimeDelegatable(@Nullable OverridesRegistry context) {
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor();
        this.delegate = context != null ? (KeyStoreServiceImpl)context.findOverride(KeyStoreServiceImpl.class, (Object)argumentsCaptor) : null;
    }

    @Override
    public KeyStore createKeyStore(KeyStoreAuth keyStoreAuth, KeyStoreType keyStoreType, KeyStoreCreationConfig config) {
        if (null == this.delegate) {
            return super.createKeyStore(keyStoreAuth, keyStoreType, config);
        }
        return this.delegate.createKeyStore(keyStoreAuth, keyStoreType, config);
    }

    @Override
    public KeyStore createKeyStore(KeyStoreAuth keyStoreAuth, KeyStoreType keyStoreType, KeyStoreCreationConfig config, Map<KeyID, Optional<SecretKeyEntry>> secretKeys) {
        if (null == this.delegate) {
            return super.createKeyStore(keyStoreAuth, keyStoreType, config, secretKeys);
        }
        return this.delegate.createKeyStore(keyStoreAuth, keyStoreType, config, secretKeys);
    }

    @Override
    public KeyStore updateKeyStoreReadKeyPassword(KeyStore current, KeyStoreAuth currentCredentials, KeyStoreAuth newCredentials) {
        if (null == this.delegate) {
            return super.updateKeyStoreReadKeyPassword(current, currentCredentials, newCredentials);
        }
        return this.delegate.updateKeyStoreReadKeyPassword(current, currentCredentials, newCredentials);
    }

    @Override
    public List<PublicKeyIDWithPublicKey> getPublicKeys(KeyStoreAccess keyStoreAccess) {
        if (null == this.delegate) {
            return super.getPublicKeys(keyStoreAccess);
        }
        return this.delegate.getPublicKeys(keyStoreAccess);
    }

    @Override
    public PrivateKey getPrivateKey(KeyStoreAccess keyStoreAccess, KeyID keyID) {
        if (null == this.delegate) {
            return super.getPrivateKey(keyStoreAccess, keyID);
        }
        return this.delegate.getPrivateKey(keyStoreAccess, keyID);
    }

    @Override
    public SecretKeySpec getSecretKey(KeyStoreAccess keyStoreAccess, KeyID keyID) {
        if (null == this.delegate) {
            return super.getSecretKey(keyStoreAccess, keyID);
        }
        return this.delegate.getSecretKey(keyStoreAccess, keyID);
    }

    @Override
    public byte[] serialize(KeyStore store, String storeId, ReadStorePassword readStorePassword) {
        if (null == this.delegate) {
            return super.serialize(store, storeId, readStorePassword);
        }
        return this.delegate.serialize(store, storeId, readStorePassword);
    }

    @Override
    public KeyStore deserialize(byte[] payload, String storeId, ReadStorePassword readStorePassword) {
        if (null == this.delegate) {
            return super.deserialize(payload, storeId, readStorePassword);
        }
        return this.delegate.deserialize(payload, storeId, readStorePassword);
    }

    public static void overrideWith(OverridesRegistry context, Function<ArgumentsCaptor, KeyStoreServiceImpl> ctorCaptor) {
        context.override(KeyStoreServiceImpl.class, args -> (KeyStoreServiceImpl)ctorCaptor.apply((ArgumentsCaptor)args));
    }

    public static class ArgumentsCaptor {
        private ArgumentsCaptor() {
        }
    }
}

