/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.encrypiton.impl.pathencryption;

import de.adorsys.datasafe.directory.api.profile.keys.PrivateKeyService;
import de.adorsys.datasafe.encrypiton.api.pathencryption.PathEncryption;
import de.adorsys.datasafe.encrypiton.api.pathencryption.encryption.SymmetricPathEncryptionService;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.encrypiton.api.types.keystore.SecretKeyIDWithKey;
import de.adorsys.datasafe.types.api.context.annotations.RuntimeDelegate;
import de.adorsys.datasafe.types.api.resource.Uri;
import javax.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RuntimeDelegate
public class PathEncryptionImpl
implements PathEncryption {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PathEncryptionImpl.class);
    private final SymmetricPathEncryptionService bucketPathEncryptionService;
    private final PrivateKeyService privateKeyService;

    @Inject
    public PathEncryptionImpl(SymmetricPathEncryptionService bucketPathEncryptionService, PrivateKeyService privateKeyService) {
        this.bucketPathEncryptionService = bucketPathEncryptionService;
        this.privateKeyService = privateKeyService;
    }

    public Uri encrypt(UserIDAuth forUser, Uri path) {
        SecretKeyIDWithKey keySpec = this.privateKeyService.pathEncryptionSecretKey(forUser);
        Uri encrypt = this.bucketPathEncryptionService.encrypt(keySpec.getSecretKey(), path);
        log.debug("encrypted path {} for user {} path {}", new Object[]{encrypt, forUser.getUserID(), path});
        return encrypt;
    }

    public Uri decrypt(UserIDAuth forUser, Uri path) {
        SecretKeyIDWithKey keySpec = this.privateKeyService.pathEncryptionSecretKey(forUser);
        Uri decrypt = this.bucketPathEncryptionService.decrypt(keySpec.getSecretKey(), path);
        log.debug("decrypted path {} for user {} path {}", new Object[]{decrypt, forUser.getUserID(), path});
        return decrypt;
    }
}

