/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.encrypiton.impl.pathencryption;

import de.adorsys.datasafe.encrypiton.impl.pathencryption.DefaultPathDigestConfig;
import de.adorsys.datasafe.encrypiton.impl.pathencryption.DefaultPathEncryption;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.inject.Inject;

public class DefaultPathEncryptionRuntimeDelegatable
extends DefaultPathEncryption {
    private final DefaultPathEncryption delegate;

    @Inject
    public DefaultPathEncryptionRuntimeDelegatable(@Nullable OverridesRegistry context, DefaultPathDigestConfig config) {
        super(config);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(config);
        this.delegate = context != null ? (DefaultPathEncryption)context.findOverride(DefaultPathEncryption.class, (Object)argumentsCaptor) : null;
    }

    @Override
    public Cipher encryptionCipher(SecretKey secretKey) {
        if (null == this.delegate) {
            return super.encryptionCipher(secretKey);
        }
        return this.delegate.encryptionCipher(secretKey);
    }

    @Override
    public Cipher decryptionCipher(SecretKey secretKey) {
        if (null == this.delegate) {
            return super.decryptionCipher(secretKey);
        }
        return this.delegate.decryptionCipher(secretKey);
    }

    @Override
    public String byteSerializer(byte[] bytes) {
        if (null == this.delegate) {
            return super.byteSerializer(bytes);
        }
        return this.delegate.byteSerializer(bytes);
    }

    @Override
    public byte[] byteDeserializer(String input) {
        if (null == this.delegate) {
            return super.byteDeserializer(input);
        }
        return this.delegate.byteDeserializer(input);
    }

    public static void overrideWith(OverridesRegistry context, Function<ArgumentsCaptor, DefaultPathEncryption> ctorCaptor) {
        context.override(DefaultPathEncryption.class, args -> (DefaultPathEncryption)ctorCaptor.apply((ArgumentsCaptor)args));
    }

    public static class ArgumentsCaptor {
        private final DefaultPathDigestConfig config;

        private ArgumentsCaptor(DefaultPathDigestConfig config) {
            this.config = config;
        }

        public DefaultPathDigestConfig getConfig() {
            return this.config;
        }
    }
}

