/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.encrypiton.impl.keystore.generator;

import de.adorsys.datasafe.encrypiton.api.types.keystore.ReadKeyPassword;
import de.adorsys.datasafe.encrypiton.impl.keystore.generator.KeyPairBuilder;
import de.adorsys.datasafe.encrypiton.impl.keystore.generator.KeyPairData;
import de.adorsys.datasafe.encrypiton.impl.keystore.generator.SingleKeyUsageSelfSignedCertBuilder;
import de.adorsys.datasafe.encrypiton.impl.keystore.types.KeyPairGenerator;
import de.adorsys.datasafe.encrypiton.impl.keystore.types.SelfSignedKeyPairData;
import java.security.KeyPair;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;

public class KeyPairGeneratorImpl
implements KeyPairGenerator {
    private static final int[] keyUsageSignature = new int[]{64};
    private static final int[] keyUsageEncryption = new int[]{32, 16, 8};
    private final String keyAlgo;
    private final Integer keySize;
    private final String serverSigAlgo;
    private final String serverKeyPairName;
    protected Integer daysAfter = 900;
    protected Boolean withCA = false;

    public KeyPairGeneratorImpl(String keyAlgo, Integer keySize, String serverSigAlgo, String serverKeyPairName) {
        this.keyAlgo = keyAlgo;
        this.keySize = keySize;
        this.serverSigAlgo = serverSigAlgo;
        this.serverKeyPairName = serverKeyPairName;
    }

    @Override
    public KeyPairData generateSignatureKey(String alias, ReadKeyPassword readKeyPassword) {
        return this.generate(keyUsageSignature, alias, readKeyPassword);
    }

    @Override
    public KeyPairData generateEncryptionKey(String alias, ReadKeyPassword readKeyPassword) {
        return this.generate(keyUsageEncryption, alias, readKeyPassword);
    }

    private KeyPairData generate(int[] keyUsages, String alias, ReadKeyPassword readKeyPassword) {
        KeyPair keyPair = new KeyPairBuilder().withKeyAlg(this.keyAlgo).withKeyLength(this.keySize).build();
        X500Name dn = new X500NameBuilder(BCStyle.INSTANCE).addRDN(BCStyle.CN, this.serverKeyPairName).build();
        SelfSignedKeyPairData keyPairData = new SingleKeyUsageSelfSignedCertBuilder().withSubjectDN(dn).withSignatureAlgo(this.serverSigAlgo).withNotAfterInDays(this.daysAfter).withCa(this.withCA).withKeyUsages(keyUsages).build(keyPair);
        return KeyPairData.builder().keyPair(keyPairData).alias(alias).readKeyPassword(readKeyPassword).build();
    }
}

