/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.encrypiton.impl.keystore.generator;

import de.adorsys.datasafe.encrypiton.impl.keystore.generator.BatchValidator;
import de.adorsys.datasafe.encrypiton.impl.keystore.generator.KeyValue;
import de.adorsys.datasafe.encrypiton.impl.keystore.generator.ListOfKeyValueBuilder;
import de.adorsys.datasafe.encrypiton.impl.keystore.generator.SerialNumberGenerator;
import de.adorsys.datasafe.encrypiton.impl.keystore.generator.V3CertificateUtils;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;

public class CaSignedCertificateBuilder {
    private boolean createCaCert;
    private X500Name subjectDN;
    private boolean subjectOnlyInAlternativeName;
    private Integer notAfterInDays;
    private Integer notBeforeInDays = 0;
    private int keyUsage = -1;
    private boolean keyUsageSet = false;
    private String signatureAlgo;
    private PublicKey subjectPublicKey;
    boolean dirty = false;

    public X509CertificateHolder build(PrivateKey issuerPrivatekey) {
        if (this.dirty) {
            throw new IllegalStateException("Builder can not be reused");
        }
        this.dirty = true;
        if (StringUtils.isBlank((CharSequence)this.signatureAlgo)) {
            String algorithm = issuerPrivatekey.getAlgorithm();
            if (StringUtils.equalsAnyIgnoreCase((CharSequence)"DSA", (CharSequence[])new CharSequence[]{algorithm})) {
                this.signatureAlgo = "SHA256withDSA";
            } else if (StringUtils.equals((CharSequence)"RSA", (CharSequence)algorithm)) {
                this.signatureAlgo = "SHA256WithRSA";
            }
        }
        Date now = new Date();
        Date notAfter = this.notAfterInDays != null ? DateUtils.addDays((Date)now, (int)this.notAfterInDays) : null;
        Date notBefore = this.notBeforeInDays != null ? DateUtils.addDays((Date)now, (int)this.notBeforeInDays) : null;
        List<KeyValue> notNullCheckList = ListOfKeyValueBuilder.newBuilder().add("X509CertificateBuilder_missing_subject_DN", this.subjectDN).add("X509CertificateBuilder_missing_subject_publicKey", this.subjectPublicKey).add("X509CertificateBuilder_missing_validity_date_notBefore", notBefore).add("X509CertificateBuilder_missing_validity_date_notAfter", notAfter).build();
        List<String> errorKeys = BatchValidator.filterNull(notNullCheckList);
        if (errorKeys == null) {
            errorKeys = new ArrayList<String>();
        }
        X500Name issuerDN = null;
        BasicConstraints basicConstraints = null;
        issuerDN = this.subjectDN;
        if (this.createCaCert) {
            basicConstraints = new BasicConstraints(true);
            this.subjectOnlyInAlternativeName = false;
        } else {
            basicConstraints = new BasicConstraints(false);
        }
        BigInteger serial = SerialNumberGenerator.uniqueSerial();
        JcaX509v3CertificateBuilder v3CertGen = null;
        if (!errorKeys.isEmpty()) {
            throw new IllegalArgumentException("Fields can not be null: " + errorKeys);
        }
        v3CertGen = new JcaX509v3CertificateBuilder(issuerDN, serial, notBefore, notAfter, this.subjectDN, this.subjectPublicKey);
        JcaX509ExtensionUtils extUtils = V3CertificateUtils.getJcaX509ExtensionUtils();
        v3CertGen.addExtension(X509Extension.basicConstraints, true, (ASN1Encodable)basicConstraints);
        v3CertGen.addExtension(X509Extension.subjectKeyIdentifier, false, (ASN1Encodable)extUtils.createSubjectKeyIdentifier(this.subjectPublicKey));
        v3CertGen.addExtension(X509Extension.authorityKeyIdentifier, false, (ASN1Encodable)extUtils.createAuthorityKeyIdentifier(this.subjectPublicKey));
        if (this.keyUsageSet) {
            v3CertGen.addExtension(X509Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(this.keyUsage));
        }
        ContentSigner signer = V3CertificateUtils.getContentSigner(issuerPrivatekey, this.signatureAlgo);
        return v3CertGen.build(signer);
    }

    public CaSignedCertificateBuilder withCa(boolean ca) {
        this.createCaCert = ca;
        return this;
    }

    public CaSignedCertificateBuilder withSubjectDN(X500Name subjectDN) {
        this.subjectDN = subjectDN;
        return this;
    }

    public CaSignedCertificateBuilder withSubjectPublicKey(PublicKey subjectPublicKey) {
        this.subjectPublicKey = subjectPublicKey;
        return this;
    }

    public CaSignedCertificateBuilder withNotAfterInDays(Integer notAfterInDays) {
        this.notAfterInDays = notAfterInDays;
        return this;
    }

    public CaSignedCertificateBuilder withNotBeforeInDays(Integer notBeforeInDays) {
        this.notBeforeInDays = notBeforeInDays;
        return this;
    }

    public CaSignedCertificateBuilder withKeyUsage(int keyUsage) {
        if (this.keyUsageSet) {
            this.keyUsage |= keyUsage;
        } else {
            this.keyUsage = keyUsage;
            this.keyUsageSet = true;
        }
        return this;
    }
}

