package de.adorsys.datasafe.encrypiton.impl.keystore;

import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyID;
import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyStoreAccess;
import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyStoreAuth;
import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyStoreCreationConfig;
import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyStoreType;
import de.adorsys.datasafe.encrypiton.api.types.keystore.PublicKeyIDWithPublicKey;
import de.adorsys.datasafe.encrypiton.api.types.keystore.ReadStorePassword;
import de.adorsys.datasafe.encrypiton.api.types.keystore.SecretKeyEntry;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import java.lang.Override;
import java.lang.String;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.crypto.spec.SecretKeySpec;
import javax.inject.Inject;

@Generated(
        value = "de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator",
        comments = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used."
)
public class KeyStoreServiceImplRuntimeDelegatable extends KeyStoreServiceImpl {
    private final KeyStoreServiceImpl delegate;

    /**
     * @param context Context class to search for overrides.
     */
    @Inject
    public KeyStoreServiceImplRuntimeDelegatable(@Nullable OverridesRegistry context) {
        super();
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor();
        delegate = context != null ? context.findOverride(KeyStoreServiceImpl.class, argumentsCaptor) : null;
    }

    @Override
    public KeyStore createKeyStore(KeyStoreAuth keyStoreAuth, KeyStoreType keyStoreType,
            KeyStoreCreationConfig config) {
        if (null == delegate) {
            return super.createKeyStore(keyStoreAuth, keyStoreType, config);
        } else {
            return delegate.createKeyStore(keyStoreAuth, keyStoreType, config);
        }
    }

    @Override
    public KeyStore createKeyStore(KeyStoreAuth keyStoreAuth, KeyStoreType keyStoreType,
            KeyStoreCreationConfig config, Map<KeyID, Optional<SecretKeyEntry>> secretKeys) {
        if (null == delegate) {
            return super.createKeyStore(keyStoreAuth, keyStoreType, config, secretKeys);
        } else {
            return delegate.createKeyStore(keyStoreAuth, keyStoreType, config, secretKeys);
        }
    }

    @Override
    public List<PublicKeyIDWithPublicKey> getPublicKeys(KeyStoreAccess keyStoreAccess) {
        if (null == delegate) {
            return super.getPublicKeys(keyStoreAccess);
        } else {
            return delegate.getPublicKeys(keyStoreAccess);
        }
    }

    @Override
    public PrivateKey getPrivateKey(KeyStoreAccess keyStoreAccess, KeyID keyID) {
        if (null == delegate) {
            return super.getPrivateKey(keyStoreAccess, keyID);
        } else {
            return delegate.getPrivateKey(keyStoreAccess, keyID);
        }
    }

    @Override
    public SecretKeySpec getSecretKey(KeyStoreAccess keyStoreAccess, KeyID keyID) {
        if (null == delegate) {
            return super.getSecretKey(keyStoreAccess, keyID);
        } else {
            return delegate.getSecretKey(keyStoreAccess, keyID);
        }
    }

    @Override
    public byte[] serialize(KeyStore store, String storeId, ReadStorePassword readStorePassword) {
        if (null == delegate) {
            return super.serialize(store, storeId, readStorePassword);
        } else {
            return delegate.serialize(store, storeId, readStorePassword);
        }
    }

    @Override
    public KeyStore deserialize(byte[] payload, String storeId,
            ReadStorePassword readStorePassword) {
        if (null == delegate) {
            return super.deserialize(payload, storeId, readStorePassword);
        } else {
            return delegate.deserialize(payload, storeId, readStorePassword);
        }
    }

    /**
     * This is a typesafe function to register overriding class into context.
     */
    public static void overrideWith(OverridesRegistry context,
            Function<ArgumentsCaptor, KeyStoreServiceImpl> ctorCaptor) {
        context.override(KeyStoreServiceImpl.class, args -> ctorCaptor.apply((ArgumentsCaptor) args));
    }

    public static class ArgumentsCaptor {
        private ArgumentsCaptor() {
        }
    }
}
