package de.adorsys.datasafe.encrypiton.impl.document;

import de.adorsys.datasafe.encrypiton.api.cmsencryption.CMSEncryptionService;
import de.adorsys.datasafe.encrypiton.api.types.keystore.PublicKeyIDWithPublicKey;
import de.adorsys.datasafe.encrypiton.api.types.keystore.SecretKeyIDWithKey;
import de.adorsys.datasafe.storage.api.actions.StorageWriteService;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import java.io.OutputStream;
import java.lang.Override;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Generated(
        value = "de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator",
        comments = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used."
)
public class CMSDocumentWriteServiceRuntimeDelegatable extends CMSDocumentWriteService {
    private final CMSDocumentWriteService delegate;

    /**
     * @param context Context class to search for overrides.
     */
    @Inject
    public CMSDocumentWriteServiceRuntimeDelegatable(@Nullable OverridesRegistry context,
            StorageWriteService writeService, CMSEncryptionService cms) {
        super(writeService, cms);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(writeService, cms);
        delegate = context != null ? context.findOverride(CMSDocumentWriteService.class, argumentsCaptor) : null;
    }

    @Override
    public OutputStream write(Map<PublicKeyIDWithPublicKey, AbsoluteLocation> recipientsWithInbox) {
        if (null == delegate) {
            return super.write(recipientsWithInbox);
        } else {
            return delegate.write(recipientsWithInbox);
        }
    }

    @Override
    public OutputStream write(AbsoluteLocation<PrivateResource> location,
            SecretKeyIDWithKey secretKey) {
        if (null == delegate) {
            return super.write(location, secretKey);
        } else {
            return delegate.write(location, secretKey);
        }
    }

    /**
     * This is a typesafe function to register overriding class into context.
     */
    public static void overrideWith(OverridesRegistry context,
            Function<ArgumentsCaptor, CMSDocumentWriteService> ctorCaptor) {
        context.override(CMSDocumentWriteService.class, args -> ctorCaptor.apply((ArgumentsCaptor) args));
    }

    public static class ArgumentsCaptor {
        private final StorageWriteService writeService;

        private final CMSEncryptionService cms;

        private ArgumentsCaptor(StorageWriteService writeService, CMSEncryptionService cms) {
            this.writeService = writeService;
            this.cms = cms;
        }

        public StorageWriteService getWriteService() {
            return writeService;
        }

        public CMSEncryptionService getCms() {
            return cms;
        }
    }
}
