/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.encrypiton.impl.pathencryption;

import de.adorsys.datasafe.encrypiton.impl.pathencryption.PathEncryptionConfig;
import de.adorsys.datasafe.encrypiton.impl.pathencryption.SymmetricPathEncryptionServiceImpl;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import de.adorsys.datasafe.types.api.resource.Uri;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import javax.inject.Inject;

public class SymmetricPathEncryptionServiceImplRuntimeDelegatable
extends SymmetricPathEncryptionServiceImpl {
    private final SymmetricPathEncryptionServiceImpl delegate;

    @Inject
    public SymmetricPathEncryptionServiceImplRuntimeDelegatable(@Nullable OverridesRegistry context, PathEncryptionConfig encryptionConfig) {
        super(encryptionConfig);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(encryptionConfig);
        this.delegate = context != null ? (SymmetricPathEncryptionServiceImpl)context.findOverride(SymmetricPathEncryptionServiceImpl.class, (Object)argumentsCaptor) : null;
    }

    @Override
    public Uri encrypt(SecretKey secretKey, Uri bucketPath) {
        if (null == this.delegate) {
            return super.encrypt(secretKey, bucketPath);
        }
        return this.delegate.encrypt(secretKey, bucketPath);
    }

    @Override
    public Uri decrypt(SecretKey secretKey, Uri bucketPath) {
        if (null == this.delegate) {
            return super.decrypt(secretKey, bucketPath);
        }
        return this.delegate.decrypt(secretKey, bucketPath);
    }

    public static void overrideWith(OverridesRegistry context, Function<ArgumentsCaptor, SymmetricPathEncryptionServiceImpl> ctorCaptor) {
        context.override(SymmetricPathEncryptionServiceImpl.class, args -> (SymmetricPathEncryptionServiceImpl)ctorCaptor.apply((ArgumentsCaptor)args));
    }

    public static class ArgumentsCaptor {
        private final PathEncryptionConfig encryptionConfig;

        private ArgumentsCaptor(PathEncryptionConfig encryptionConfig) {
            this.encryptionConfig = encryptionConfig;
        }

        public PathEncryptionConfig getEncryptionConfig() {
            return this.encryptionConfig;
        }
    }
}

