/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.encrypiton.impl.keystore;

import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyEntry;
import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyID;
import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyStoreCreationConfig;
import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyStoreType;
import de.adorsys.datasafe.encrypiton.api.types.keystore.ReadKeyPassword;
import de.adorsys.datasafe.encrypiton.api.types.keystore.SecretKeyEntry;
import de.adorsys.datasafe.encrypiton.api.types.keystore.SecretKeyGenerator;
import de.adorsys.datasafe.encrypiton.api.types.keystore.exceptions.KeyStoreConfigException;
import de.adorsys.datasafe.encrypiton.impl.keystore.generator.KeyPairGeneratorImpl;
import de.adorsys.datasafe.encrypiton.impl.keystore.generator.KeyStoreCreationConfigImpl;
import de.adorsys.datasafe.encrypiton.impl.keystore.generator.KeystoreBuilder;
import de.adorsys.datasafe.encrypiton.impl.keystore.generator.SecretKeyGeneratorImpl;
import de.adorsys.datasafe.encrypiton.impl.keystore.types.KeyPairEntry;
import de.adorsys.datasafe.types.api.utils.Obfuscate;
import java.security.KeyStore;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KeyStoreGenerator.class);
    @NonNull
    private final KeyStoreType keyStoreType;
    @NonNull
    private final String serverKeyPairAliasPrefix;
    @NonNull
    private final KeyStoreCreationConfigImpl config;
    @NonNull
    private final ReadKeyPassword readKeyPassword;
    @NonNull
    private final Map<KeyID, Optional<SecretKeyEntry>> secretKeys;

    protected KeyStoreGenerator(KeyStoreCreationConfig config, KeyStoreType keyStoreType, String serverKeyPairAliasPrefix, ReadKeyPassword readKeyPassword, Map<KeyID, Optional<SecretKeyEntry>> secretKeys) {
        this.config = new KeyStoreCreationConfigImpl(config);
        this.keyStoreType = keyStoreType;
        this.serverKeyPairAliasPrefix = "KEYSTORE-ID-0";
        this.readKeyPassword = readKeyPassword;
        this.secretKeys = secretKeys;
        log.debug("Keystore ID ignored {}", (Object)Obfuscate.secure((Object)serverKeyPairAliasPrefix));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStore generate() {
        if (this.config.getEncKeyNumber() == 0 && this.secretKeys.isEmpty() && this.config.getSignKeyNumber() == 0) {
            throw new KeyStoreConfigException("Configuration of keystore must at least contain one key");
        }
        KeyStore keyStore = null;
        Date startTime = new Date();
        try {
            KeyPairEntry signatureKeyPair;
            int i;
            String keyStoreID = this.serverKeyPairAliasPrefix;
            KeystoreBuilder keystoreBuilder = new KeystoreBuilder().withStoreType(this.keyStoreType);
            KeyPairGeneratorImpl encKeyPairGenerator = this.config.getEncKeyPairGenerator(keyStoreID);
            int numberOfEncKeyPairs = this.config.getEncKeyNumber();
            for (i = 0; i < numberOfEncKeyPairs; ++i) {
                signatureKeyPair = encKeyPairGenerator.generateEncryptionKey(this.serverKeyPairAliasPrefix + UUID.randomUUID().toString(), this.readKeyPassword);
                keystoreBuilder = keystoreBuilder.withKeyEntry(signatureKeyPair);
            }
            KeyPairGeneratorImpl signKeyPairGenerator = this.config.getSignKeyPairGenerator(keyStoreID);
            int numberOfSignKeyPairs = this.config.getSignKeyNumber();
            for (i = 0; i < numberOfSignKeyPairs; ++i) {
                signatureKeyPair = signKeyPairGenerator.generateSignatureKey(this.serverKeyPairAliasPrefix + UUID.randomUUID().toString(), this.readKeyPassword);
                keystoreBuilder = keystoreBuilder.withKeyEntry(signatureKeyPair);
            }
            SecretKeyGeneratorImpl secretKeyGenerator = this.config.getSecretKeyGenerator(keyStoreID);
            for (Map.Entry<KeyID, Optional<SecretKeyEntry>> keyEntry : this.secretKeys.entrySet()) {
                keystoreBuilder = this.buildSecretKey(keyEntry, secretKeyGenerator, this.readKeyPassword, keystoreBuilder);
            }
            KeyStore keyStore2 = keyStore = keystoreBuilder.build();
            return keyStore2;
        }
        finally {
            Date stopTime = new Date();
            long duration = stopTime.getTime() - startTime.getTime();
            log.debug("KeyStoreGeneration (milliseconds) DURATION WAS {}", (Object)duration);
        }
    }

    private KeystoreBuilder buildSecretKey(Map.Entry<KeyID, Optional<SecretKeyEntry>> keyEntry, SecretKeyGenerator secretKeyGenerator, ReadKeyPassword readKeyPassword, KeystoreBuilder keystoreBuilder) {
        SecretKeyEntry secretKeyData = keyEntry.getValue().orElse(secretKeyGenerator.generate(keyEntry.getKey().getValue(), readKeyPassword));
        return keystoreBuilder.withKeyEntry((KeyEntry)secretKeyData);
    }

    @Generated
    public static KeyStoreGeneratorBuilder builder() {
        return new KeyStoreGeneratorBuilder();
    }

    @Generated
    public static class KeyStoreGeneratorBuilder {
        @Generated
        private KeyStoreCreationConfig config;
        @Generated
        private KeyStoreType keyStoreType;
        @Generated
        private String serverKeyPairAliasPrefix;
        @Generated
        private ReadKeyPassword readKeyPassword;
        @Generated
        private Map<KeyID, Optional<SecretKeyEntry>> secretKeys;

        @Generated
        KeyStoreGeneratorBuilder() {
        }

        @Generated
        public KeyStoreGeneratorBuilder config(KeyStoreCreationConfig config) {
            this.config = config;
            return this;
        }

        @Generated
        public KeyStoreGeneratorBuilder keyStoreType(KeyStoreType keyStoreType) {
            this.keyStoreType = keyStoreType;
            return this;
        }

        @Generated
        public KeyStoreGeneratorBuilder serverKeyPairAliasPrefix(String serverKeyPairAliasPrefix) {
            this.serverKeyPairAliasPrefix = serverKeyPairAliasPrefix;
            return this;
        }

        @Generated
        public KeyStoreGeneratorBuilder readKeyPassword(ReadKeyPassword readKeyPassword) {
            this.readKeyPassword = readKeyPassword;
            return this;
        }

        @Generated
        public KeyStoreGeneratorBuilder secretKeys(Map<KeyID, Optional<SecretKeyEntry>> secretKeys) {
            this.secretKeys = secretKeys;
            return this;
        }

        @Generated
        public KeyStoreGenerator build() {
            return new KeyStoreGenerator(this.config, this.keyStoreType, this.serverKeyPairAliasPrefix, this.readKeyPassword, this.secretKeys);
        }

        @Generated
        public String toString() {
            return "KeyStoreGenerator.KeyStoreGeneratorBuilder(config=" + this.config + ", keyStoreType=" + this.keyStoreType + ", serverKeyPairAliasPrefix=" + this.serverKeyPairAliasPrefix + ", readKeyPassword=" + this.readKeyPassword + ", secretKeys=" + this.secretKeys + ")";
        }
    }
}

