/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.encrypiton.impl.document;

import com.google.common.collect.ImmutableList;
import de.adorsys.datasafe.encrypiton.api.cmsencryption.CMSEncryptionService;
import de.adorsys.datasafe.encrypiton.api.document.EncryptedDocumentWriteService;
import de.adorsys.datasafe.encrypiton.api.types.keystore.PublicKeyIDWithPublicKey;
import de.adorsys.datasafe.encrypiton.api.types.keystore.SecretKeyIDWithKey;
import de.adorsys.datasafe.storage.api.actions.StorageWriteService;
import de.adorsys.datasafe.types.api.context.annotations.RuntimeDelegate;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import lombok.Generated;

@RuntimeDelegate
public class CMSDocumentWriteService
implements EncryptedDocumentWriteService {
    private final StorageWriteService writeService;
    private final CMSEncryptionService cms;

    @Inject
    public CMSDocumentWriteService(StorageWriteService writeService, CMSEncryptionService cms) {
        this.writeService = writeService;
        this.cms = cms;
    }

    public OutputStream write(Map<PublicKeyIDWithPublicKey, AbsoluteLocation> recipientsWithInbox) {
        FanOutStream dfsSink = new FanOutStream(recipientsWithInbox.values().stream().map(arg_0 -> ((StorageWriteService)this.writeService).write(arg_0)).collect(Collectors.toList()));
        OutputStream encryptionSink = this.cms.buildEncryptionOutputStream((OutputStream)dfsSink, recipientsWithInbox.keySet());
        return new CloseCoordinatingStream(encryptionSink, (List<OutputStream>)ImmutableList.of((Object)encryptionSink, (Object)dfsSink));
    }

    public OutputStream write(AbsoluteLocation<PrivateResource> location, SecretKeyIDWithKey secretKey) {
        OutputStream dfsSink = this.writeService.write(location);
        OutputStream encryptionSink = this.cms.buildEncryptionOutputStream(dfsSink, secretKey.getSecretKey(), secretKey.getKeyID());
        return new CloseCoordinatingStream(encryptionSink, (List<OutputStream>)ImmutableList.of((Object)encryptionSink, (Object)dfsSink));
    }

    private static final class FanOutStream
    extends OutputStream {
        private final List<OutputStream> destinations;

        @Override
        public void write(int b) throws IOException {
            for (OutputStream destination : this.destinations) {
                destination.write(b);
            }
        }

        @Override
        public void write(byte[] bytes, int off, int len) throws IOException {
            for (OutputStream destination : this.destinations) {
                destination.write(bytes, off, len);
            }
        }

        @Override
        public void close() {
            super.close();
            for (OutputStream destination : this.destinations) {
                destination.close();
            }
        }

        @Generated
        public FanOutStream(List<OutputStream> destinations) {
            this.destinations = destinations;
        }
    }

    private static final class CloseCoordinatingStream
    extends OutputStream {
        private final OutputStream streamToWrite;
        private final List<OutputStream> streamsToClose;

        @Override
        public void write(int b) throws IOException {
            this.streamToWrite.write(b);
        }

        @Override
        public void write(byte[] bytes, int off, int len) throws IOException {
            this.streamToWrite.write(bytes, off, len);
        }

        @Override
        public void close() {
            super.close();
            this.streamsToClose.forEach(CloseCoordinatingStream::doClose);
        }

        private static void doClose(OutputStream stream) {
            stream.close();
        }

        @Generated
        public CloseCoordinatingStream(OutputStream streamToWrite, List<OutputStream> streamsToClose) {
            this.streamToWrite = streamToWrite;
            this.streamsToClose = streamsToClose;
        }
    }
}

