package de.adorsys.datasafe.encrypiton.impl.pathencryption;

import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import de.adorsys.datasafe.types.api.resource.Uri;
import java.lang.Override;
import java.util.function.Function;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import javax.inject.Inject;

@Generated(
        value = "de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator",
        comments = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used."
)
public class SymmetricPathEncryptionServiceImplRuntimeDelegatable extends SymmetricPathEncryptionServiceImpl {
    private final SymmetricPathEncryptionServiceImpl delegate;

    /**
     * @param context Context class to search for overrides.
     */
    @Inject
    public SymmetricPathEncryptionServiceImplRuntimeDelegatable(@Nullable OverridesRegistry context,
            PathEncryptionConfig encryptionConfig) {
        super(encryptionConfig);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(encryptionConfig);
        delegate = context != null ? context.findOverride(SymmetricPathEncryptionServiceImpl.class, argumentsCaptor) : null;
    }

    @Override
    public Uri encrypt(SecretKey secretKey, Uri bucketPath) {
        if (null == delegate) {
            return super.encrypt(secretKey, bucketPath);
        } else {
            return delegate.encrypt(secretKey, bucketPath);
        }
    }

    @Override
    public Uri decrypt(SecretKey secretKey, Uri bucketPath) {
        if (null == delegate) {
            return super.decrypt(secretKey, bucketPath);
        } else {
            return delegate.decrypt(secretKey, bucketPath);
        }
    }

    /**
     * This is a typesafe function to register overriding class into context.
     */
    public static void overrideWith(OverridesRegistry context,
            Function<ArgumentsCaptor, SymmetricPathEncryptionServiceImpl> ctorCaptor) {
        context.override(SymmetricPathEncryptionServiceImpl.class, args -> ctorCaptor.apply((ArgumentsCaptor) args));
    }

    public static class ArgumentsCaptor {
        private final PathEncryptionConfig encryptionConfig;

        private ArgumentsCaptor(PathEncryptionConfig encryptionConfig) {
            this.encryptionConfig = encryptionConfig;
        }

        public PathEncryptionConfig getEncryptionConfig() {
            return encryptionConfig;
        }
    }
}
