package de.adorsys.datasafe.encrypiton.impl.pathencryption;

import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import java.lang.Override;
import java.lang.String;
import java.util.function.Function;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.inject.Inject;

@Generated(
        value = "de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator",
        comments = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used."
)
public class DefaultPathEncryptionRuntimeDelegatable extends DefaultPathEncryption {
    private final DefaultPathEncryption delegate;

    /**
     * @param context Context class to search for overrides.
     */
    @Inject
    public DefaultPathEncryptionRuntimeDelegatable(@Nullable OverridesRegistry context,
            DefaultPathDigestConfig config) {
        super(config);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(config);
        delegate = context != null ? context.findOverride(DefaultPathEncryption.class, argumentsCaptor) : null;
    }

    @Override
    public Cipher encryptionCipher(SecretKey secretKey) {
        if (null == delegate) {
            return super.encryptionCipher(secretKey);
        } else {
            return delegate.encryptionCipher(secretKey);
        }
    }

    @Override
    public Cipher decryptionCipher(SecretKey secretKey) {
        if (null == delegate) {
            return super.decryptionCipher(secretKey);
        } else {
            return delegate.decryptionCipher(secretKey);
        }
    }

    @Override
    public String byteSerializer(byte[] bytes) {
        if (null == delegate) {
            return super.byteSerializer(bytes);
        } else {
            return delegate.byteSerializer(bytes);
        }
    }

    @Override
    public byte[] byteDeserializer(String input) {
        if (null == delegate) {
            return super.byteDeserializer(input);
        } else {
            return delegate.byteDeserializer(input);
        }
    }

    /**
     * This is a typesafe function to register overriding class into context.
     */
    public static void overrideWith(OverridesRegistry context,
            Function<ArgumentsCaptor, DefaultPathEncryption> ctorCaptor) {
        context.override(DefaultPathEncryption.class, args -> ctorCaptor.apply((ArgumentsCaptor) args));
    }

    public static class ArgumentsCaptor {
        private final DefaultPathDigestConfig config;

        private ArgumentsCaptor(DefaultPathDigestConfig config) {
            this.config = config;
        }

        public DefaultPathDigestConfig getConfig() {
            return config;
        }
    }
}
