/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.encrypiton.api.types.keystore;

import de.adorsys.datasafe.encrypiton.api.types.keystore.ReadKeyPassword;
import de.adorsys.datasafe.encrypiton.api.types.keystore.ReadStorePassword;
import de.adorsys.datasafe.encrypiton.api.types.keystore.exceptions.KeyStoreAuthException;
import de.adorsys.datasafe.types.api.utils.Obfuscate;

public class KeyStoreAuth {
    private final ReadStorePassword readStorePassword;
    private final ReadKeyPassword readKeyPassword;

    public KeyStoreAuth(ReadStorePassword readStorePassword, ReadKeyPassword readKeyPassword) {
        this.readStorePassword = readStorePassword;
        this.readKeyPassword = readKeyPassword;
    }

    public ReadStorePassword getReadStorePassword() {
        if (this.readStorePassword == null) {
            throw new KeyStoreAuthException("Access to READ STORE PASSWORD not allowed.");
        }
        return this.readStorePassword;
    }

    public ReadKeyPassword getReadKeyPassword() {
        if (this.readKeyPassword == null) {
            throw new KeyStoreAuthException("Access to READ KEY PASSWORD not allowed");
        }
        return this.readKeyPassword;
    }

    public String toString() {
        return "KeyStoreAuth{" + Obfuscate.secureSensitive((Object)this.readStorePassword) + ", " + Obfuscate.secureSensitive((Object)this.readKeyPassword) + '}';
    }
}

