package de.adorsys.datasafe.directory.impl.profile.operations.actions;

import de.adorsys.datasafe.directory.api.profile.keys.PrivateKeyService;
import de.adorsys.datasafe.directory.api.profile.keys.StorageKeyStoreOperations;
import de.adorsys.datasafe.directory.api.types.StorageCredentials;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import de.adorsys.datasafe.types.api.resource.StorageIdentifier;
import jakarta.annotation.Generated;
import java.lang.Override;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Generated(
        value = "de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator",
        comments = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used."
)
public class ProfileStorageCredentialsServiceImplRuntimeDelegatable extends ProfileStorageCredentialsServiceImpl {
    private final ProfileStorageCredentialsServiceImpl delegate;

    /**
     * @param context Context class to search for overrides.
     */
    @Inject
    public ProfileStorageCredentialsServiceImplRuntimeDelegatable(
            @Nullable OverridesRegistry context, StorageKeyStoreOperations keyStoreOper,
            PrivateKeyService privateKeyService) {
        super(keyStoreOper, privateKeyService);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(keyStoreOper, privateKeyService);
        delegate = context != null ? context.findOverride(ProfileStorageCredentialsServiceImpl.class, argumentsCaptor) : null;
    }

    @Override
    public Set<StorageIdentifier> listRegisteredStorageCredentials(UserIDAuth user) {
        if (null == delegate) {
            return super.listRegisteredStorageCredentials(user);
        } else {
            return delegate.listRegisteredStorageCredentials(user);
        }
    }

    @Override
    public void registerStorageCredentials(UserIDAuth user, StorageIdentifier storageId,
            StorageCredentials credentials) {
        if (null == delegate) {
            super.registerStorageCredentials(user, storageId, credentials);
        } else {
            delegate.registerStorageCredentials(user, storageId, credentials);
        }
    }

    @Override
    public void deregisterStorageCredentials(UserIDAuth user, StorageIdentifier storageId) {
        if (null == delegate) {
            super.deregisterStorageCredentials(user, storageId);
        } else {
            delegate.deregisterStorageCredentials(user, storageId);
        }
    }

    /**
     * This is a typesafe function to register overriding class into context.
     */
    public static void overrideWith(OverridesRegistry context,
            Function<ArgumentsCaptor, ProfileStorageCredentialsServiceImpl> ctorCaptor) {
        context.override(ProfileStorageCredentialsServiceImpl.class, args -> ctorCaptor.apply((ArgumentsCaptor) args));
    }

    public static class ArgumentsCaptor {
        private final StorageKeyStoreOperations keyStoreOper;

        private final PrivateKeyService privateKeyService;

        private ArgumentsCaptor(StorageKeyStoreOperations keyStoreOper,
                PrivateKeyService privateKeyService) {
            this.keyStoreOper = keyStoreOper;
            this.privateKeyService = privateKeyService;
        }

        public StorageKeyStoreOperations getKeyStoreOper() {
            return keyStoreOper;
        }

        public PrivateKeyService getPrivateKeyService() {
            return privateKeyService;
        }
    }
}
