package de.adorsys.datasafe.directory.impl.profile.operations.actions;

import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.directory.api.profile.dfs.BucketAccessService;
import de.adorsys.datasafe.directory.api.types.UserPrivateProfile;
import de.adorsys.datasafe.directory.api.types.UserPublicProfile;
import de.adorsys.datasafe.directory.impl.profile.operations.UserProfileCache;
import de.adorsys.datasafe.directory.impl.profile.serde.GsonSerde;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.storage.api.actions.StorageCheckService;
import de.adorsys.datasafe.storage.api.actions.StorageReadService;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import jakarta.annotation.Generated;
import java.lang.Override;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Generated(
        value = "de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator",
        comments = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used."
)
public class ProfileRetrievalServiceImplRuntimeDelegatable extends ProfileRetrievalServiceImpl {
    private final ProfileRetrievalServiceImpl delegate;

    /**
     * @param context Context class to search for overrides.
     */
    @Inject
    public ProfileRetrievalServiceImplRuntimeDelegatable(@Nullable OverridesRegistry context,
            DFSConfig dfsConfig, StorageReadService readService, StorageCheckService checkService,
            BucketAccessService access, GsonSerde serde, UserProfileCache userProfileCache) {
        super(dfsConfig, readService, checkService, access, serde, userProfileCache);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(dfsConfig, readService, checkService, access, serde, userProfileCache);
        delegate = context != null ? context.findOverride(ProfileRetrievalServiceImpl.class, argumentsCaptor) : null;
    }

    @Override
    public UserPublicProfile publicProfile(UserID ofUser) {
        if (null == delegate) {
            return super.publicProfile(ofUser);
        } else {
            return delegate.publicProfile(ofUser);
        }
    }

    @Override
    public UserPrivateProfile privateProfile(UserIDAuth ofUser) {
        if (null == delegate) {
            return super.privateProfile(ofUser);
        } else {
            return delegate.privateProfile(ofUser);
        }
    }

    @Override
    public boolean userExists(UserID ofUser) {
        if (null == delegate) {
            return super.userExists(ofUser);
        } else {
            return delegate.userExists(ofUser);
        }
    }

    /**
     * This is a typesafe function to register overriding class into context.
     */
    public static void overrideWith(OverridesRegistry context,
            Function<ArgumentsCaptor, ProfileRetrievalServiceImpl> ctorCaptor) {
        context.override(ProfileRetrievalServiceImpl.class, args -> ctorCaptor.apply((ArgumentsCaptor) args));
    }

    public static class ArgumentsCaptor {
        private final DFSConfig dfsConfig;

        private final StorageReadService readService;

        private final StorageCheckService checkService;

        private final BucketAccessService access;

        private final GsonSerde serde;

        private final UserProfileCache userProfileCache;

        private ArgumentsCaptor(DFSConfig dfsConfig, StorageReadService readService,
                StorageCheckService checkService, BucketAccessService access, GsonSerde serde,
                UserProfileCache userProfileCache) {
            this.dfsConfig = dfsConfig;
            this.readService = readService;
            this.checkService = checkService;
            this.access = access;
            this.serde = serde;
            this.userProfileCache = userProfileCache;
        }

        public DFSConfig getDfsConfig() {
            return dfsConfig;
        }

        public StorageReadService getReadService() {
            return readService;
        }

        public StorageCheckService getCheckService() {
            return checkService;
        }

        public BucketAccessService getAccess() {
            return access;
        }

        public GsonSerde getSerde() {
            return serde;
        }

        public UserProfileCache getUserProfileCache() {
            return userProfileCache;
        }
    }
}
