package de.adorsys.datasafe.directory.impl.profile.operations.actions;

import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.directory.api.profile.dfs.BucketAccessService;
import de.adorsys.datasafe.directory.api.profile.keys.DocumentKeyStoreOperations;
import de.adorsys.datasafe.directory.api.profile.keys.StorageKeyStoreOperations;
import de.adorsys.datasafe.directory.api.types.CreateUserPrivateProfile;
import de.adorsys.datasafe.directory.api.types.CreateUserPublicProfile;
import de.adorsys.datasafe.directory.api.types.UserPrivateProfile;
import de.adorsys.datasafe.directory.impl.profile.serde.GsonSerde;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.storage.api.actions.StorageCheckService;
import de.adorsys.datasafe.storage.api.actions.StorageWriteService;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import jakarta.annotation.Generated;
import java.lang.Override;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Generated(
        value = "de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator",
        comments = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used."
)
public class ProfileRegistrationServiceImplRuntimeDelegatable extends ProfileRegistrationServiceImpl {
    private final ProfileRegistrationServiceImpl delegate;

    /**
     * @param context Context class to search for overrides.
     */
    @Inject
    public ProfileRegistrationServiceImplRuntimeDelegatable(@Nullable OverridesRegistry context,
            ProfileStoreService storeProfile, StorageKeyStoreOperations storageKeyStoreOper,
            DocumentKeyStoreOperations keyStoreOper, BucketAccessService access,
            StorageCheckService checkService, StorageWriteService writeService, GsonSerde serde,
            DFSConfig dfsConfig) {
        super(storeProfile, storageKeyStoreOper, keyStoreOper, access, checkService, writeService, serde, dfsConfig);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(storeProfile, storageKeyStoreOper, keyStoreOper, access, checkService, writeService, serde, dfsConfig);
        delegate = context != null ? context.findOverride(ProfileRegistrationServiceImpl.class, argumentsCaptor) : null;
    }

    @Override
    public void registerPublic(CreateUserPublicProfile profile) {
        if (null == delegate) {
            super.registerPublic(profile);
        } else {
            delegate.registerPublic(profile);
        }
    }

    @Override
    public void registerPrivate(CreateUserPrivateProfile profile) {
        if (null == delegate) {
            super.registerPrivate(profile);
        } else {
            delegate.registerPrivate(profile);
        }
    }

    @Override
    public void createAllAllowableKeystores(UserIDAuth user, UserPrivateProfile profile) {
        if (null == delegate) {
            super.createAllAllowableKeystores(user, profile);
        } else {
            delegate.createAllAllowableKeystores(user, profile);
        }
    }

    @Override
    public void createDocumentKeystore(UserIDAuth user, UserPrivateProfile profile) {
        if (null == delegate) {
            super.createDocumentKeystore(user, profile);
        } else {
            delegate.createDocumentKeystore(user, profile);
        }
    }

    @Override
    public void createStorageKeystore(UserIDAuth user) {
        if (null == delegate) {
            super.createStorageKeystore(user);
        } else {
            delegate.createStorageKeystore(user);
        }
    }

    @Override
    public void registerUsingDefaults(UserIDAuth user) {
        if (null == delegate) {
            super.registerUsingDefaults(user);
        } else {
            delegate.registerUsingDefaults(user);
        }
    }

    /**
     * This is a typesafe function to register overriding class into context.
     */
    public static void overrideWith(OverridesRegistry context,
            Function<ArgumentsCaptor, ProfileRegistrationServiceImpl> ctorCaptor) {
        context.override(ProfileRegistrationServiceImpl.class, args -> ctorCaptor.apply((ArgumentsCaptor) args));
    }

    public static class ArgumentsCaptor {
        private final ProfileStoreService storeProfile;

        private final StorageKeyStoreOperations storageKeyStoreOper;

        private final DocumentKeyStoreOperations keyStoreOper;

        private final BucketAccessService access;

        private final StorageCheckService checkService;

        private final StorageWriteService writeService;

        private final GsonSerde serde;

        private final DFSConfig dfsConfig;

        private ArgumentsCaptor(ProfileStoreService storeProfile,
                StorageKeyStoreOperations storageKeyStoreOper,
                DocumentKeyStoreOperations keyStoreOper, BucketAccessService access,
                StorageCheckService checkService, StorageWriteService writeService, GsonSerde serde,
                DFSConfig dfsConfig) {
            this.storeProfile = storeProfile;
            this.storageKeyStoreOper = storageKeyStoreOper;
            this.keyStoreOper = keyStoreOper;
            this.access = access;
            this.checkService = checkService;
            this.writeService = writeService;
            this.serde = serde;
            this.dfsConfig = dfsConfig;
        }

        public ProfileStoreService getStoreProfile() {
            return storeProfile;
        }

        public StorageKeyStoreOperations getStorageKeyStoreOper() {
            return storageKeyStoreOper;
        }

        public DocumentKeyStoreOperations getKeyStoreOper() {
            return keyStoreOper;
        }

        public BucketAccessService getAccess() {
            return access;
        }

        public StorageCheckService getCheckService() {
            return checkService;
        }

        public StorageWriteService getWriteService() {
            return writeService;
        }

        public GsonSerde getSerde() {
            return serde;
        }

        public DFSConfig getDfsConfig() {
            return dfsConfig;
        }
    }
}
