package de.adorsys.datasafe.directory.impl.profile.operations;

import de.adorsys.datasafe.directory.api.types.UserPrivateProfile;
import de.adorsys.datasafe.directory.api.types.UserPublicProfile;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import jakarta.annotation.Generated;
import java.lang.Override;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Generated(
        value = "de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator",
        comments = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used."
)
public class DefaultUserProfileCacheRuntimeDelegatable extends DefaultUserProfileCache {
    private final DefaultUserProfileCache delegate;

    /**
     * @param context Context class to search for overrides.
     */
    @Inject
    public DefaultUserProfileCacheRuntimeDelegatable(@Nullable OverridesRegistry context,
            Map<UserID, UserPublicProfile> publicProfile,
            Map<UserID, UserPrivateProfile> privateProfile) {
        super(publicProfile, privateProfile);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(publicProfile, privateProfile);
        delegate = context != null ? context.findOverride(DefaultUserProfileCache.class, argumentsCaptor) : null;
    }

    @Override
    public Map<UserID, UserPublicProfile> getPublicProfile() {
        if (null == delegate) {
            return super.getPublicProfile();
        } else {
            return delegate.getPublicProfile();
        }
    }

    @Override
    public Map<UserID, UserPrivateProfile> getPrivateProfile() {
        if (null == delegate) {
            return super.getPrivateProfile();
        } else {
            return delegate.getPrivateProfile();
        }
    }

    /**
     * This is a typesafe function to register overriding class into context.
     */
    public static void overrideWith(OverridesRegistry context,
            Function<ArgumentsCaptor, DefaultUserProfileCache> ctorCaptor) {
        context.override(DefaultUserProfileCache.class, args -> ctorCaptor.apply((ArgumentsCaptor) args));
    }

    public static class ArgumentsCaptor {
        private final Map<UserID, UserPublicProfile> publicProfile;

        private final Map<UserID, UserPrivateProfile> privateProfile;

        private ArgumentsCaptor(Map<UserID, UserPublicProfile> publicProfile,
                Map<UserID, UserPrivateProfile> privateProfile) {
            this.publicProfile = publicProfile;
            this.privateProfile = privateProfile;
        }

        public Map<UserID, UserPublicProfile> getPublicProfile() {
            return publicProfile;
        }

        public Map<UserID, UserPrivateProfile> getPrivateProfile() {
            return privateProfile;
        }
    }
}
